package xen42.canadamod.item;

import com.mojang.serialization.Codec;
import com.google.common.collect.Lists;
import com.mojang.serialization.DataResult;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_5632;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9334;
import xen42.canadamod.CanadaItems;

import org.apache.commons.lang3.math.Fraction;
import org.jetbrains.annotations.Nullable;

/// Modified from BundleContentsComponent because its marked final and can't be extended
public class ThermosContentsComponent implements class_5632 {
    public static final ThermosContentsComponent DEFAULT = new ThermosContentsComponent(List.of());
    public static final Codec<ThermosContentsComponent> CODEC;
    public static final class_9139<class_9129, ThermosContentsComponent> PACKET_CODEC;
    private static final int ADD_TO_NEW_SLOT = -1;
    public static final int field_52591 = -1;
    final List<class_1799> stacks;
    final Fraction occupancy;
    final int selectedStackIndex;

    ThermosContentsComponent(List<class_1799> stacks, Fraction occupancy, int selectedStackIndex) {
        this.stacks = stacks;
        this.occupancy = occupancy;
        this.selectedStackIndex = selectedStackIndex;
    }

    private static DataResult<ThermosContentsComponent> validateOccupancy(List<class_1799> stacks) {
        try {
            Fraction fraction = calculateOccupancy(stacks);
            return DataResult.success(new ThermosContentsComponent(stacks, fraction, -1));
        } catch (ArithmeticException var2) {
            return DataResult.error(() -> {
            return "Excessive total bundle weight";
            });
        }
    }

    public ThermosContentsComponent(List<class_1799> stacks) {
        this(stacks, calculateOccupancy(stacks), -1);
    }

    private static Fraction calculateOccupancy(List<class_1799> stacks) {
        Fraction fraction = Fraction.ZERO;

        class_1799 itemStack;
        for(Iterator var2 = stacks.iterator(); var2.hasNext(); fraction = fraction.add(getOccupancy(itemStack).multiplyBy(Fraction.getFraction(itemStack.method_7947(), 1)))) {
            itemStack = (class_1799)var2.next();
        }

        return fraction;
    }

    // Modified to not care about max count
    public static Fraction getOccupancy(class_1799 stack) {
        return Fraction.getFraction(1, 64);
    }

    // Modified
    public static boolean canBeBundled(class_1799 stack) {
        // Only allow food items going in, or their containers
        if (stack.method_7960()) {
            return false;
        }

        var isSoup = stack.method_58694(class_9334.field_53964) != null && stack.method_7914() < 64;
        var isContainer = stack.method_31574(class_1802.field_8550) || stack.method_31574(class_1802.field_8469) || stack.method_31574(class_1802.field_8428);

        return isSoup || isContainer;
    }

    public int getNumberOfStacksShown() {
        int i = this.size();
        int j = i > 12 ? 11 : 12;
        int k = i % 4;
        int l = k == 0 ? 0 : 4 - k;
        return Math.min(i, j - l);
    }

    public class_1799 get(int index) {
        return (class_1799)this.stacks.get(index);
    }

    public Stream<class_1799> stream() {
        return this.stacks.stream().map(class_1799::method_7972);
    }

    public Iterable<class_1799> iterate() {
        return this.stacks;
    }

    public Iterable<class_1799> iterateCopy() {
        return Lists.transform(this.stacks, class_1799::method_7972);
    }

    public int size() {
        return this.stacks.size();
    }

    public Fraction getOccupancy() {
        return this.occupancy;
    }

    public boolean isEmpty() {
        return this.stacks.isEmpty();
    }

    public int getSelectedStackIndex() {
        return this.selectedStackIndex;
    }

    public boolean hasSelectedStack() {
        return this.selectedStackIndex != -1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        } else if (!(o instanceof ThermosContentsComponent)) {
            return false;
        } else {
            ThermosContentsComponent ThermosContentsComponent = (ThermosContentsComponent)o;
            return this.occupancy.equals(ThermosContentsComponent.occupancy) && class_1799.method_57362(this.stacks, ThermosContentsComponent.stacks);
        }
    }

    public int hashCode() {
        return class_1799.method_57361(this.stacks);
    }

    public String toString() {
        return "ThermosContents" + String.valueOf(this.stacks);
    }

    static {
        CODEC = class_1799.field_24671.listOf().flatXmap(ThermosContentsComponent::validateOccupancy, (component) -> {
            return DataResult.success(component.stacks);
        });
        PACKET_CODEC = class_1799.field_48349.method_56433(class_9135.method_56363()).method_56432(ThermosContentsComponent::new, (component) -> {
            return component.stacks;
        });
    }

    public class Builder {
        private final List<class_1799> stacks;
        private Fraction occupancy;
        private int selectedStackIndex;

        public Builder(ThermosContentsComponent base) {
            this.stacks = new ArrayList(base.stacks);
            this.occupancy = base.occupancy;
            this.selectedStackIndex = base.selectedStackIndex;
        }

        public Builder clear() {
            this.stacks.clear();
            this.occupancy = Fraction.ZERO;
            this.selectedStackIndex = -1;
            return this;
        }

        private int getInsertionIndex(class_1799 stack) {
            if (!stack.method_7946()) {
                return -1;
            } else {
                for(int i = 0; i < this.stacks.size(); ++i) {
                    if (class_1799.method_31577((class_1799)this.stacks.get(i), stack)) {
                    return i;
                    }
                }

                return -1;
            }
        }

        private int getMaxAllowed(class_1799 stack) {
            Fraction fraction = Fraction.ONE.subtract(this.occupancy);
            return Math.max(fraction.divideBy(ThermosContentsComponent.getOccupancy(stack)).intValue(), 0);
        }

        public int add(class_1799 stack) {
            if (!ThermosContentsComponent.canBeBundled(stack)) {
                return 0;
            } else {
                int i = Math.min(stack.method_7947(), this.getMaxAllowed(stack));
                if (i == 0) {
                    return 0;
                } else {
                    this.occupancy = this.occupancy.add(ThermosContentsComponent.getOccupancy(stack).multiplyBy(Fraction.getFraction(i, 1)));
                    int j = this.getInsertionIndex(stack);
                    if (j != -1) {
                    class_1799 itemStack = (class_1799)this.stacks.remove(j);
                    class_1799 itemStack2 = itemStack.method_46651(itemStack.method_7947() + i);
                    stack.method_7934(i);
                    this.stacks.add(0, itemStack2);
                    } else {
                    this.stacks.add(0, stack.method_7971(i));
                    }

                    return i;
                }
            }
        }

        public int add(class_1735 slot, class_1657 player) {
            class_1799 itemStack = slot.method_7677();
            int i = this.getMaxAllowed(itemStack);
            return ThermosContentsComponent.canBeBundled(itemStack) ? this.add(slot.method_32753(itemStack.method_7947(), i, player)) : 0;
        }

        public void setSelectedStackIndex(int selectedStackIndex) {
            this.selectedStackIndex = this.selectedStackIndex != selectedStackIndex && !this.isOutOfBounds(selectedStackIndex) ? selectedStackIndex : -1;
        }

        private boolean isOutOfBounds(int index) {
            return index < 0 || index >= this.stacks.size();
        }

        @Nullable
        public class_1799 removeSelected() {
            if (this.stacks.isEmpty()) {
                return null;
            } else {
                int i = this.isOutOfBounds(this.selectedStackIndex) ? 0 : this.selectedStackIndex;
                class_1799 itemStack = ((class_1799)this.stacks.remove(i)).method_7972();
                this.occupancy = this.occupancy.subtract(ThermosContentsComponent.getOccupancy(itemStack).multiplyBy(Fraction.getFraction(itemStack.method_7947(), 1)));
                this.setSelectedStackIndex(-1);
                return itemStack;
            }
        }

        public Fraction getOccupancy() {
            return this.occupancy;
        }

        public ThermosContentsComponent build() {
            return new ThermosContentsComponent(List.copyOf(this.stacks), this.occupancy, this.selectedStackIndex);
        }
        }
}
