package xen42.canadamod.item;

import java.util.Optional;
import net.minecraft.class_10124;
import net.minecraft.class_10712;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_5328;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_5632;
import net.minecraft.class_9334;
import net.minecraft.class_9848;
import org.apache.commons.lang3.math.Fraction;

import org.jetbrains.annotations.Nullable;
import xen42.canadamod.CanadaItems;
import xen42.canadamod.CanadaMod;
import xen42.canadamod.item.ThermosContentsComponent.Builder;

public class ThermosItem extends class_1792 {
    @Nullable
    private class_1799 currentFoodStack;

    @Nullable
    private class_10124 currentConsumableComponent;

    private int selectedIndex = -1;

    public ThermosItem(class_1793 settings) {
        super(settings);
    }

    @Override
    public class_1269 method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 itemStack = user.method_5998(hand);

        selectFirstFood(itemStack, user);

        if (currentConsumableComponent != null) {
            return currentConsumableComponent.method_62845(user, itemStack, hand);
        } 

        return class_1269.field_5811;
    }

    public class_1799 method_7861(class_1799 stack, class_1937 world, class_1309 user) {
        if (currentConsumableComponent != null) {
            var finishedConsumption = currentConsumableComponent.method_62847(world, user, currentFoodStack.method_7972());
            
            // If it has a remainder give that instead
            var remainder = currentFoodStack.method_7972().method_7910(world, user);
            if (remainder != currentFoodStack) {
                finishedConsumption = remainder;
            }

            ThermosContentsComponent thermosContentsComponent = (ThermosContentsComponent)stack.method_58694(CanadaItems.THERMOS_CONTENTS);
            ThermosContentsComponent.Builder builder = thermosContentsComponent.new Builder(thermosContentsComponent);

            builder.setSelectedStackIndex(selectedIndex);
            builder.removeSelected();
            
            builder.add(finishedConsumption);
            stack.method_57379(CanadaItems.THERMOS_CONTENTS, builder.build());

            currentConsumableComponent = null;
            currentFoodStack = null;
            selectedIndex = -1;
        }
        return stack;
    }

    @Override
    public class_1839 method_7853(class_1799 stack) {
        if (currentConsumableComponent != null) {
            return currentConsumableComponent.comp_3086();
        } 
        else {
            return class_1839.field_8952;
        }
    }

    @Override
    public int method_7881(class_1799 stack, class_1309 user) {
        if (currentConsumableComponent != null) {
            return currentConsumableComponent.method_62841();
        } else {
            return 0;
        }
    }

    @Override
    public boolean method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        this.currentConsumableComponent = null;
        currentFoodStack = null;
        selectedIndex = -1;
        return false;
    }

    private void selectFirstFood(class_1799 stack, class_1657 player) {
        var thermosContentsComponent = stack.method_58694(CanadaItems.THERMOS_CONTENTS);
        var builder = thermosContentsComponent.new Builder(thermosContentsComponent);

        for (int index = 0; index < 64; index++) {
            builder.setSelectedStackIndex(index);
            var itemStack = builder.removeSelected();

            if (itemStack != null && itemStack.method_58694(class_9334.field_53964) != null) {
                currentFoodStack = itemStack;
                currentConsumableComponent = itemStack.method_58694(class_9334.field_53964);
                selectedIndex = index;
                return;
            } 
        }

        currentFoodStack = null;
        currentConsumableComponent = null;
        selectedIndex = -1;
    }

    @Override
    public void method_7852(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
        if (currentConsumableComponent != null && currentConsumableComponent.method_62842(remainingUseTicks)) {
            currentConsumableComponent.method_62843(user.method_59922(), user, currentFoodStack, 5);
        }
    }

    /// BELOW IS PURE BUNDLE ITEM

    public static final int TOOLTIP_STACKS_COLUMNS = 4;
    public static final int TOOLTIP_STACKS_ROWS = 3;
    public static final int MAX_TOOLTIP_STACKS_SHOWN = 12;
    public static final int MAX_TOOLTIP_STACKS_SHOWN_WHEN_TOO_MANY_TYPES = 11;
    private static final int FULL_ITEM_BAR_COLOR = class_9848.method_61318(1.0F, 1.0F, 0.33F, 0.33F);
    private static final int ITEM_BAR_COLOR = class_9848.method_61318(1.0F, 0.44F, 0.53F, 1.0F);

    public static float getAmountFilled(class_1799 stack) {
        ThermosContentsComponent thermosContentsComponent = (ThermosContentsComponent)stack.method_58695(CanadaItems.THERMOS_CONTENTS, ThermosContentsComponent.DEFAULT);
        return thermosContentsComponent.getOccupancy().floatValue();
    }

    public boolean method_31565(class_1799 stack, class_1735 slot, class_5536 clickType, class_1657 player) {
        ThermosContentsComponent thermosContentsComponent = (ThermosContentsComponent)stack.method_58694(CanadaItems.THERMOS_CONTENTS);
        if (thermosContentsComponent == null) {
            return false;
        } else {
            class_1799 itemStack = slot.method_7677();
            ThermosContentsComponent.Builder builder = thermosContentsComponent.new Builder(thermosContentsComponent);
            if (clickType == class_5536.field_27013 && !itemStack.method_7960()) {
                if (builder.add(slot, player) > 0) {
                    playInsertSound(player);
                } else {
                    playInsertFailSound(player);
                }

                stack.method_57379(CanadaItems.THERMOS_CONTENTS, builder.build());
                this.onContentChanged(player);
                return true;
            } else if (clickType == class_5536.field_27014 && itemStack.method_7960()) {
                class_1799 itemStack2 = builder.removeSelected();
                if (itemStack2 != null) {
                    class_1799 itemStack3 = slot.method_32756(itemStack2);
                    if (itemStack3.method_7947() > 0) {
                        builder.add(itemStack3);
                    } else {
                        playRemoveOneSound(player);
                    }
                }

                stack.method_57379(CanadaItems.THERMOS_CONTENTS, builder.build());
                this.onContentChanged(player);
                return true;
            } else {
                return false;
            }
        }
    }

    public boolean method_31566(class_1799 stack, class_1799 otherStack, class_1735 slot, class_5536 clickType, class_1657 player, class_5630 cursorStackReference) {
        if (clickType == class_5536.field_27013 && otherStack.method_7960()) {
            setSelectedStackIndex(stack, -1);
            return false;
        } else {
            ThermosContentsComponent thermosContentsComponent = (ThermosContentsComponent)stack.method_58694(CanadaItems.THERMOS_CONTENTS);
            if (thermosContentsComponent == null) {
                return false;
            } else {
                ThermosContentsComponent.Builder builder = thermosContentsComponent.new Builder(thermosContentsComponent);
                if (clickType == class_5536.field_27013 && !otherStack.method_7960()) {
                    if (slot.method_32754(player) && builder.add(otherStack) > 0) {
                        playInsertSound(player);
                    } else {
                        playInsertFailSound(player);
                    }

                    stack.method_57379(CanadaItems.THERMOS_CONTENTS, builder.build());
                    this.onContentChanged(player);
                    return true;
                } else if (clickType == class_5536.field_27014 && otherStack.method_7960()) {
                    if (slot.method_32754(player)) {
                        class_1799 itemStack = builder.removeSelected();
                        if (itemStack != null) {
                            playRemoveOneSound(player);
                            cursorStackReference.method_32332(itemStack);
                        }
                    }

                    stack.method_57379(CanadaItems.THERMOS_CONTENTS, builder.build());
                    this.onContentChanged(player);
                    return true;
                } else {
                    setSelectedStackIndex(stack, -1);
                    return false;
                }
            }
        }
    }

    public boolean method_31567(class_1799 stack) {
        ThermosContentsComponent thermosContentsComponent = (ThermosContentsComponent)stack.method_58695(CanadaItems.THERMOS_CONTENTS, ThermosContentsComponent.DEFAULT);
        return thermosContentsComponent.getOccupancy().compareTo(Fraction.ZERO) > 0;
    }

    public int method_31569(class_1799 stack) {
        ThermosContentsComponent thermosContentsComponent = (ThermosContentsComponent)stack.method_58695(CanadaItems.THERMOS_CONTENTS, ThermosContentsComponent.DEFAULT);
        return Math.min(1 + class_3532.method_59515(thermosContentsComponent.getOccupancy(), 12), 13);
    }

    public int method_31571(class_1799 stack) {
        ThermosContentsComponent thermosContentsComponent = (ThermosContentsComponent)stack.method_58695(CanadaItems.THERMOS_CONTENTS, ThermosContentsComponent.DEFAULT);
        return thermosContentsComponent.getOccupancy().compareTo(Fraction.ONE) >= 0 ? FULL_ITEM_BAR_COLOR : ITEM_BAR_COLOR;
    }

    public static void setSelectedStackIndex(class_1799 stack, int selectedStackIndex) {
        ThermosContentsComponent thermosContentsComponent = (ThermosContentsComponent)stack.method_58694(CanadaItems.THERMOS_CONTENTS);
        if (thermosContentsComponent != null) {
            ThermosContentsComponent.Builder builder = thermosContentsComponent.new Builder(thermosContentsComponent);
            builder.setSelectedStackIndex(selectedStackIndex);
            stack.method_57379(CanadaItems.THERMOS_CONTENTS, builder.build());
        }
    }

    public static boolean hasSelectedStack(class_1799 stack) {
        ThermosContentsComponent ThermosContentsComponent = (ThermosContentsComponent)stack.method_58694(CanadaItems.THERMOS_CONTENTS);
        return ThermosContentsComponent != null && ThermosContentsComponent.getSelectedStackIndex() != -1;
    }

    public static int getSelectedStackIndex(class_1799 stack) {
        ThermosContentsComponent thermosContentsComponent = (ThermosContentsComponent)stack.method_58695(CanadaItems.THERMOS_CONTENTS, ThermosContentsComponent.DEFAULT);
        return thermosContentsComponent.getSelectedStackIndex();
    }

    public static class_1799 getSelectedStack(class_1799 stack) {
        ThermosContentsComponent thermosContentsComponent = (ThermosContentsComponent)stack.method_58694(CanadaItems.THERMOS_CONTENTS);
        return thermosContentsComponent != null && thermosContentsComponent.getSelectedStackIndex() != -1 ? thermosContentsComponent.get(thermosContentsComponent.getSelectedStackIndex()) : class_1799.field_8037;
    }

    public static int getNumberOfStacksShown(class_1799 stack) {
        ThermosContentsComponent thermosContentsComponent = (ThermosContentsComponent)stack.method_58695(CanadaItems.THERMOS_CONTENTS, ThermosContentsComponent.DEFAULT);
        return thermosContentsComponent.getNumberOfStacksShown();
    }

    public Optional<class_5632> method_32346(class_1799 stack) {
        class_10712 tooltipDisplayComponent = (class_10712)stack.method_58695(class_9334.field_56400, class_10712.field_56318);
        return !tooltipDisplayComponent.method_67214(CanadaItems.THERMOS_CONTENTS) ? Optional.empty() : Optional.ofNullable((ThermosContentsComponent)stack.method_58694(CanadaItems.THERMOS_CONTENTS)).map(ThermosTooltipData::new);
    }

    public void method_33261(class_1542 entity) {
        ThermosContentsComponent thermosContentsComponent = (ThermosContentsComponent)entity.method_6983().method_58694(CanadaItems.THERMOS_CONTENTS);
        if (thermosContentsComponent != null) {
            entity.method_6983().method_57379(CanadaItems.THERMOS_CONTENTS, ThermosContentsComponent.DEFAULT);
            class_5328.method_33263(entity, thermosContentsComponent.iterateCopy());
        }
    }

    private static void playRemoveOneSound(class_1297 entity) {
        entity.method_5783(class_3417.field_34377, 0.8F, 0.8F + entity.method_37908().method_8409().method_43057() * 0.4F);
    }

    private static void playInsertSound(class_1297 entity) {
        entity.method_5783(class_3417.field_34376, 0.8F, 0.8F + entity.method_37908().method_8409().method_43057() * 0.4F);
    }

    private static void playInsertFailSound(class_1297 entity) {
        entity.method_5783(class_3417.field_52372, 1.0F, 1.0F);
    }

    private void onContentChanged(class_1657 user) {
        class_1703 screenHandler = user.field_7512;
        if (screenHandler != null) {
            screenHandler.method_7609(user.method_31548());
        }

    }
}
