package xen42.canadamod.mixin;

import net.minecraft.class_1293;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_3489;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xen42.canadamod.CanadaItems;
import xen42.canadamod.CanadaMod;

@Mixin(class_1657.class)
public abstract class PlayerEntityMixin {
    @Shadow
    protected abstract boolean isEquipped(class_1792 item);

    @Inject(at = @At("HEAD"), method = "tick")
    public void tick(CallbackInfo info) {
        var player = (class_1657)(Object)this;

        var doBeaver = isEquipped(CanadaItems.BEAVER_HELMET) && player.method_6047().method_31573(class_3489.field_42612);
        var doMoose = isEquipped(CanadaItems.MOOSE_HELMET);

        if (doMoose) {
            player.method_6092(new class_1293(CanadaMod.MOOSE_EFFECT, 110, 0, false, false, true));
        }
        if (doBeaver) {
            player.method_6092(new class_1293(CanadaMod.BEAVER_EFFECT, 110, 0, false, false, true));
        }
    }
}
