package xen42.canadamod.mixin.client;

import java.util.List;
import java.util.Optional;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import net.minecraft.class_8001;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xen42.canadamod.gui.ThermosTooltipComponent;
import xen42.canadamod.item.ThermosTooltipData;

// Have to patch all uses of TooltipComponent::of (for TooltipData)

@Mixin(class_332.class)
public class DrawContextMixin {
    @Inject(at = @At("HEAD"), 
        method = "drawTooltip(Lnet/minecraft/client/font/TextRenderer;Ljava/util/List;Ljava/util/Optional;IILnet/minecraft/util/Identifier;)V",
        cancellable = true)
	private void drawTooltip(class_327 textRenderer, List<class_2561> text, Optional<class_5632> data, int x, int y, @Nullable class_2960 texture, CallbackInfo info) {
        if (data.isPresent() && data.get() instanceof ThermosTooltipData thermosTooltipData) {
            var list = (List)text.stream().map(class_2561::method_30937).map(class_5684::method_32662).collect(class_156.method_58579());

            list.add(list.isEmpty() ? 0 : 1, new ThermosTooltipComponent(thermosTooltipData.contents()));

            var drawContext = (class_332)(Object)this;
            drawContext.method_51435(textRenderer, list, x, y, class_8001.field_41687, texture);
            
            info.cancel();
        }
	}
}
