package xen42.canadamod.recipe;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_10295;
import net.minecraft.class_10302;
import net.minecraft.class_10302.class_10307;
import net.minecraft.class_10355;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_3956;
import net.minecraft.class_7225.class_7874;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9887;
import org.jetbrains.annotations.VisibleForTesting;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import xen42.canadamod.CanadaBlocks;
import xen42.canadamod.CanadaMod;

public class CookingPotRecipe implements class_1860<CookingPotRecipeInput> {
    public final class_1799 result;
    public final String group;
	public final List<class_1856> ingredients;
    public final boolean requiresBowl;
    public final boolean requiresBottle;

    public CookingPotRecipe(String group, class_1799 result, List<class_1856> ingredients, boolean requiresBowl, boolean requiresBottle) {
        this.group = group;
        this.result = result;
        this.ingredients = ingredients;
        this.requiresBowl = requiresBowl;
        this.requiresBottle = requiresBottle;
    }

    @Override
    public class_1799 craft(CookingPotRecipeInput input, class_7874 registries) {
        return this.result.method_7972();
    }

	@VisibleForTesting
	public List<Optional<class_1856>> getIngredients() {
		return this.ingredients.stream().map(x -> Optional.of(x)).collect(Collectors.toList());
	}

	@Override
	public class_9887 method_61671() {
		return class_9887.method_61686(this.ingredients);
	}

	@Override
	public class_10355 method_64668() {
		return CanadaMod.COOKING_POT_RECIPE_BOOK_CATEGORY;
	}

	@Override
	public class_1865<? extends CookingPotRecipe> method_8119() {
		return CanadaMod.COOKING_POT_RECIPE_SERIALIZER;
	}

	@Override
	public class_3956<CookingPotRecipe> method_17716() {
		return CanadaMod.COOKING_POT_RECIPE_TYPE;
	}

    @Override
	public boolean method_8118() {
		return false;
	}

    @Override
	public boolean method_49188() {
		return true;
	}

    @Override
	public String method_8112() {
		return this.group;
	}

	@Override
	public List<class_10295> method_64664() {
        var containerItem = this.requiresBottle ? class_1802.field_8469 : (this.requiresBowl ? class_1802.field_8428 : null);
        var containerDisplay = containerItem == null ? class_10302.class_10305.field_54681 : new class_10302.class_10306(containerItem);
        var ingredientDisplays = this.ingredients.stream().map(class_1856::method_64673).toList();
        var cookingPotItem = CanadaBlocks.COOKING_POT.method_8389();
		return List.of(
            new CookingPotRecipeDisplay(ingredientDisplays, containerDisplay,
                new class_10307(this.result), new class_10302.class_10306(cookingPotItem))
        );
	}

    @Override
    public boolean matches(CookingPotRecipeInput input, class_1937 world) {
        var flagHasBottle = false;
        var flagHasBowl = false;
        // Skip output and fuel slots
        for (int i = 2; i < input.stacks.size(); i++) {
            var stack = input.stacks.get(i);
            if (stack.method_31574(class_1802.field_8428)) {
                flagHasBowl = true;
            }
            else if (stack.method_31574(class_1802.field_8469)) {
                flagHasBottle = true;
            }
            else {
                // Check that all ingredients match an input
                if (!ingredients.stream().anyMatch(ingredient -> stack.method_7960() || class_1856.method_61676(Optional.of(ingredient), stack))) {
                    return false;
                }
            }

        }

        // Check that all inputs match an ingredient
        for (var ingredient : ingredients) {
            if (!input.stacks.stream().anyMatch(stack -> class_1856.method_61676(Optional.of(ingredient), stack))) {
                return false;
            }
        }

        if (ingredients.size() != input.stacks.subList(3, input.stacks.size()).stream().filter(x -> !x.method_7960()).count()) {
            return false;
        }

        if (this.requiresBottle != flagHasBottle) {
            return false;
        }
        if (this.requiresBowl != flagHasBowl) {
            return false;
        }

        return true;
    }

    public static class Serializer implements class_1865<CookingPotRecipe> {
		public static final MapCodec<CookingPotRecipe> CODEC = RecordCodecBuilder.mapCodec(
			instance -> instance.group(
					Codec.STRING.optionalFieldOf("group", "").forGetter(recipe -> recipe.group),
					class_1799.field_24671.fieldOf("result").forGetter(recipe -> recipe.result),
					class_1856.field_46095.listOf(1, 4).fieldOf("ingredients").forGetter(recipe -> recipe.ingredients),
                    Codec.BOOL.optionalFieldOf("requiresBowl", false).forGetter(recipe -> recipe.requiresBowl),
                    Codec.BOOL.optionalFieldOf("requiresBottle", false).forGetter(recipe -> recipe.requiresBottle)
				)
				.apply(instance, CookingPotRecipe::new)
		);
		public static final class_9139<class_9129, CookingPotRecipe> PACKET_CODEC = class_9139.method_56437(
				CookingPotRecipe.Serializer::write, CookingPotRecipe.Serializer::read
		);

		@Override
		public MapCodec<CookingPotRecipe> method_53736() {
			return CODEC;
		}

		@Deprecated
		@Override
		public class_9139<class_9129, CookingPotRecipe> method_56104() {
			return PACKET_CODEC;
		}

		private static CookingPotRecipe read(class_9129 buf) {
			var string = buf.method_19772();
			var result = class_1799.field_48349.decode(buf);
            var ingredientsCount = buf.readInt();
            var ingredients = new ArrayList<class_1856>();
            for (int i = 0; i < ingredientsCount; i++) {
			    ingredients.add(class_1856.field_48355.decode(buf));
            }
            var requiresBottle = buf.readBoolean();
            var requiresBowl = buf.readBoolean();

			return new CookingPotRecipe(string, result, ingredients, requiresBottle, requiresBowl);
		}

		private static void write(class_9129 buf, CookingPotRecipe recipe) {
			buf.method_10814(recipe.group);
			class_1799.field_48349.encode(buf, recipe.result);
            buf.method_53002(recipe.ingredients.size());
            for (var ingredient : recipe.ingredients) {
			    class_1856.field_48355.encode(buf, ingredient);
            }
            buf.method_52964(recipe.requiresBottle);
            buf.method_52964(recipe.requiresBowl);
		}
	}
}
