package xen42.canadamod.recipe;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_175;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_2119;
import net.minecraft.class_2446;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5797;
import net.minecraft.class_6862;
import net.minecraft.class_7871;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8782;
import net.minecraft.class_8790;
import org.jetbrains.annotations.Nullable;
import xen42.canadamod.CanadaMod;

public class CookingPotRecipeJsonBuilder implements class_5797 {

	private final Map<String, class_175<?>> criteria = new LinkedHashMap<String, class_175<?>>();
	private final class_1799 result;
    @Nullable
    private String group;
    private final ArrayList<class_1856> _inputsList;
    private boolean _requiresBowl;
    private boolean _requiresBottle;
    private final class_7871<class_1792> _registryLookup;

    public CookingPotRecipeJsonBuilder(class_7871<class_1792> registryLookup, class_1935 result, int count) {
        this.result = new class_1799(result, count);

        this._registryLookup = registryLookup;
        _inputsList = new ArrayList<>();
    }

    public CookingPotRecipeJsonBuilder requiresBowl() {
        this._requiresBowl = true;
        this._requiresBottle = false;
        return this;
    }

    public CookingPotRecipeJsonBuilder requiresBottle() {
        this._requiresBottle = true;
        this._requiresBowl = false;
        return this;
    }

	public CookingPotRecipeJsonBuilder input(class_1935 item, class_2446 recipeGenerator) {
		this._inputsList.add(class_1856.method_8101(item));
        return this.method_33530(class_2446.method_32807(item), recipeGenerator.method_10426(item));
	}

	public CookingPotRecipeJsonBuilder input(class_6862<class_1792> tag, class_2446 recipeGenerator) {
		this._inputsList.add(class_1856.method_8106(_registryLookup.method_46735(tag)));
        return this.method_33530("has_" + tag.getName(), recipeGenerator.method_10420(tag));
	}

    @Override
    public CookingPotRecipeJsonBuilder method_33530(String name, class_175<?> criterion) {
		this.criteria.put(name, criterion);
		return this;
    }

    @Override
    public class_1792 method_36441() {
        return this.result.method_7909();
    }

    @Override
    public CookingPotRecipeJsonBuilder method_33529(@Nullable String group) {
		this.group = group;
		return this;
    }

    @Override
    public void method_17972(class_8790 exporter, class_5321<class_1860<?>> recipeKey) {
        if (this.criteria.isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + recipeKey.method_29177());
        }

        if (_inputsList.size() > 4) {
            throw new IllegalStateException("Too many inputs!");
        }

        if (group == null) {
            group = "";
        }

        var recipe = new CookingPotRecipe(this.group, this.result, this._inputsList, this._requiresBowl, this._requiresBottle);

		class_161.class_162 builder = exporter.method_53818()
			.method_705("has_the_recipe", class_2119.method_27847(recipeKey))
			.method_703(class_170.class_171.method_753(recipeKey))
			.method_704(class_8782.class_8797.field_1257);
        
		this.criteria.forEach(builder::method_705);

		exporter.method_53819(recipeKey, recipe, builder.method_695(recipeKey.method_29177().method_45138("recipes/cooking_pot/")));
    }

    @Override
    public void method_10431(class_8790 exporter) {
		this.method_17972(exporter, class_5321.method_29179(class_7924.field_52178, method_36442(this.method_36441())));
    }

    @Override
	public void method_36443(class_8790 exporter, String recipePath) {
		class_2960 identifier = method_36442(this.method_36441());
		class_2960 identifier2 = class_2960.method_60655(CanadaMod.MOD_ID, recipePath);
		if (identifier2.equals(identifier)) {
			throw new IllegalStateException("Recipe " + recipePath + " should remove its 'save' argument as it is equal to default one");
		} else {
			this.method_17972(exporter, class_5321.method_29179(class_7924.field_52178, identifier2));
		}
	}

    public static class_2960 method_36442(class_1935 item) {
		return class_2960.method_60655(CanadaMod.MOD_ID, class_7923.field_41178.method_10221(item.method_8389()).method_12832());
	}
}
