package xen42.canadamod.screen;

import java.util.List;
import net.minecraft.class_10295;
import net.minecraft.class_10302;
import net.minecraft.class_10352;
import net.minecraft.class_1735;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_507;
import net.minecraft.class_516;
import net.minecraft.class_8666;
import net.minecraft.class_9875;
import net.minecraft.class_9934;
import xen42.canadamod.CanadaBlocks;
import xen42.canadamod.CanadaMod;
import xen42.canadamod.recipe.CookingPotRecipeDisplay;

public class CookingPotRecipeBookWidget extends class_507<CookingPotScreenHandler> {
	private static final class_2561 TOGGLE_CRAFTABLE_TEXT = class_2561.method_43471("gui.recipebook.toggleRecipes.craftable");

	private static final List<class_507.class_10329> TABS = List.of(
		new class_507.class_10329(CanadaBlocks.COOKING_POT.method_8389(), CanadaMod.COOKING_POT_RECIPE_BOOK_CATEGORY)
	);

	private static final class_8666 TEXTURES = new class_8666(
		class_2960.method_60656("recipe_book/filter_enabled"),
		class_2960.method_60656("recipe_book/filter_disabled"),
		class_2960.method_60656("recipe_book/filter_enabled_highlighted"),
		class_2960.method_60656("recipe_book/filter_disabled_highlighted")
	);

    public CookingPotRecipeBookWidget(CookingPotScreenHandler craftingScreenHandler) {
        super(craftingScreenHandler, TABS);
    }

    @Override
    protected class_2561 method_17064() {
		return TOGGLE_CRAFTABLE_TEXT;
    }

    @Override
    protected boolean method_62023(class_1735 slot) {
		return this.field_3095.getOutputSlot() == slot || this.field_3095.getInputSlots().contains(slot) || 
        this.field_3095.getContainerSlot() == slot || this.field_3095.getFuelSlot() == slot;
    }

    @Override
    protected void method_62024(class_516 recipeResultCollection, class_9875 recipeFinder) {
		recipeResultCollection.method_64884(recipeFinder, this::canDisplay);
    }

    private boolean canDisplay(class_10295 display) {
		return true;
	}

    @Override
    protected void method_2585() {
		this.field_3088.method_1962(TEXTURES);
    }

    @Override
    protected void method_64868(class_9934 ghostRecipe, class_10295 display, class_10352 context) {
		var cookingPotDisplay = (CookingPotRecipeDisplay)display;
		ghostRecipe.method_64874(this.field_3095.getOutputSlot(), context, cookingPotDisplay.comp_3258());

		List<class_1735> inputSlots = this.field_3095.getInputSlots();
		List<class_10302> ingredients = cookingPotDisplay.ingredients(); 
		for (int i = 0; i < inputSlots.size(); i++) {
			if (i >= ingredients.size()) {
				continue;
			}
			ghostRecipe.method_64872(inputSlots.get(i), context, ingredients.get(i));
		}
		
		ghostRecipe.method_64872(this.field_3095.getContainerSlot(), context, cookingPotDisplay.containers());
    }
}
