package xen42.canadamod.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.class_10225;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import xen42.canadamod.CanadaBlocks;
import xen42.canadamod.CanadaItems;

public class TreeTapBlock extends class_2383 {
    public static int MAX_SAP = 4;
    public static class_2758 SAP_LEVEL = class_2758.method_11867("sap_level", 0, MAX_SAP);
    public static final MapCodec<TreeTapBlock> CODEC = method_54094(TreeTapBlock::new);

    public final class_265 northShape;
    public final class_265 southShape;
    public final class_265 eastShape;
    public final class_265 westShape;

    public TreeTapBlock(class_2251 settings) {
        super(settings);
        method_9590((this.field_10647.method_11664()).method_11657(SAP_LEVEL, 0));

        var width = 12;
        this.southShape = class_2248.method_9541(0, 0, 0, 16f, 16f, width);
        this.northShape = class_2248.method_9541(0, 0, 16 - width, 16f, 16f, 16f);
        this.eastShape = class_2248.method_9541(0, 0, 0, width, 16f, 16f);
        this.westShape = class_2248.method_9541(16 - width, 0, 0, 16f, 16f, 16f);
    }

    public MapCodec<? extends TreeTapBlock> method_53969() {
        return field_46280;
    }

    @Override
    protected class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        switch (state.method_11654(field_11177)) {
            case field_11043:
                return northShape;
            case field_11035:
                return southShape;
            case field_11034:
                return eastShape;
            case field_11039:
                return westShape;
            default:
                break; 
        }
        return westShape;
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        var direction = state.method_11654(field_11177);
        if (direction == class_2350.field_11036 || direction == class_2350.field_11033) {
            return false;
        }
        else {
            var blockPos = pos.method_10093(direction.method_10153());
            return world.method_8320(blockPos).method_26206((class_1922)world, blockPos, direction);
        }
    }

    public class_1792 getReturnItem(class_2680 state, class_1937 world, class_2338 pos) {
        var tappedBlock = world.method_8320(pos.method_10081(state.method_11654(field_11177).method_10153().method_62675()));

        if (tappedBlock.method_27852(class_2246.field_54715)) {
            return class_1802.field_55037;
        }
        else if (tappedBlock.method_27852(CanadaBlocks.MAPLE_LOG)) {
            return CanadaItems.MAPLE_SAP;
        }
        else if (tappedBlock.method_26164(class_3481.field_15475)) {
            return CanadaItems.SAP;
        }
        else {
            return null;
        }
    }

    @Override
    protected void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        var pair = getReturnItem(state, world, pos);

        if (pair != null && !isFull(state)) {
            world.method_8501(pos, state.method_11657(SAP_LEVEL, state.method_11654(SAP_LEVEL) + 1));
            world.method_67392(class_3417.field_28037, class_3419.field_15245, 1f, 1f);
            world.method_43276(class_5712.field_28733, pos, class_5712.class_7397.method_43287(state));
        }
    }

    public boolean isFull(class_2680 state) {
        return state.method_11654(SAP_LEVEL) == MAX_SAP;
    }

    @Override
    protected boolean method_9542(class_2680 state) {
        return !isFull(state);
    }

    @Override
    protected class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        var returnItem = getReturnItem(state, world, pos);

        if (returnItem == null) {
            return class_1269.field_5814;
        }

        if(state.method_11654(SAP_LEVEL) > 0) {
            world.method_8501(pos, state.method_11657(SAP_LEVEL, state.method_11654(SAP_LEVEL) - 1));
            world.method_43128(player, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14779, class_3419.field_15245, 1.0F, 1.0F);

            player.method_64399(new class_1799(returnItem));

            return class_1269.field_21466;
        }
        else {
            return class_1269.field_5811;
        }
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[] { SAP_LEVEL, field_11177 });
    }

    @Override
    protected int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        return state.method_11654(SAP_LEVEL);
    }

    @Override
    protected class_2680 method_9559(class_2680 state, class_4538 world, class_10225 tickView, class_2338 pos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random) {
        if (direction == (state.method_11654(field_11177)).method_10153() && !state.method_26184(world, pos)) {
            return class_2246.field_10124.method_9564(); 
        }
        else {
            return super.method_9559(state, world, tickView, pos, direction, neighborPos, neighborState, random);
        }
    }

    @Override
    public class_2680 method_9605(class_1750 ctx) {
        var dir = ctx.method_8038();
        // Should never happen but want to avoid a crash
        if (dir == class_2350.field_11036 || dir == class_2350.field_11033) {
            dir = class_2350.field_11043;
        }
        return method_9564().method_11657(SAP_LEVEL, 0).method_11657(field_11177, dir);
    }
}
