package xen42.canadamod.entities;

import org.jetbrains.annotations.Nullable;

import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1353;
import net.minecraft.class_1361;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1378;
import net.minecraft.class_1391;
import net.minecraft.class_1394;
import net.minecraft.class_1409;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2398;
import net.minecraft.class_247;
import net.minecraft.class_2487;
import net.minecraft.class_259;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5757;
import net.minecraft.class_7094;
import xen42.canadamod.CanadaItems;
import xen42.canadamod.CanadaMod;
import xen42.canadamod.CanadaSounds;

public class BeaverEntity extends class_1429 {
    private static final class_2940<Integer> CHOP_FATIGUE = class_2945.method_12791(BeaverEntity.class, class_2943.field_13327);
    private static final class_2940<Integer> CHOP_FRENZY = class_2945.method_12791(BeaverEntity.class, class_2943.field_13327);

    @Nullable
    private class_2338 choppingTree;

    public final class_7094 chopAnimationState;

    public boolean isChopping;

    public BeaverEntity(class_1299<? extends class_1429> entityType, class_1937 world) {
        super(entityType, world);
        //this.moveControl = new BeaverMoveControl(this);
        var mobNavigation = (class_1409)this.method_5942();
        mobNavigation.method_6354(true);
        chopAnimationState = new class_7094();
    }

    private static final class_4048 BABY_BASE_DIMENSIONS = class_1299.field_6085.method_18386().method_18383(0.5F).method_55685(0.665F);

    protected void method_5959() {
        this.field_6201.method_6277(0, new class_1347(this));
        this.field_6201.method_6277(1, new class_1374(this, 1.25D));
        this.field_6201.method_6277(3, new class_1341(this, 1.0D));
        this.field_6201.method_6277(4, new class_1391(this, 1.2D, stack -> this.isTemptItem(stack), false));
        this.field_6201.method_6277(5, new class_1353(this, 1.1D));
        this.field_6201.method_6277(6, new class_1394(this, 1.0D));
        this.field_6201.method_6277(7, new class_1361(this, class_1657.class, 6.0F));
        this.field_6201.method_6277(8, new class_1376(this));
        this.field_6201.method_6277(9, new BeaverChopTreeGoal(this));
    }

    public static class_5132.class_5133 createBeaverAttributes() {
        return class_1429.method_61457()
            .method_26868(class_5134.field_23716, 5.0f)
            .method_26868(class_5134.field_23719, 0.25f)
            .method_26868(class_5134.field_51578, 2f)
            .method_26867(class_5134.field_51583);
    }

    @Override
    public void method_5773() {
        super.method_5773();
        updateAnimations();

        if (this.method_5841().method_12789(CHOP_FATIGUE) > 0) {
            this.method_5841().method_12778(CHOP_FATIGUE, this.method_5841().method_12789(CHOP_FATIGUE) - 1);
        }
        if (this.method_5841().method_12789(CHOP_FRENZY) > 0) {
            this.method_5841().method_12778(CHOP_FRENZY, this.method_5841().method_12789(CHOP_FRENZY) - 1);
        }
    }

    public void updateAnimations() {
        if (isChopping && !chopAnimationState.method_41327()) {
            chopAnimationState.method_41322(this.field_6012);
        }
        if (!isChopping && chopAnimationState.method_41327()) {
            chopAnimationState.method_41325();
        }
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);

        builder.method_56912(CHOP_FATIGUE, this.field_5974.method_39332(20 * 60 * 3, 20 * 60 * 10));
        builder.method_56912(CHOP_FRENZY, 0);
    }

    @Override
    public boolean method_6481(class_1799 stack) {
        return stack.method_31574(class_1802.field_8600);
    }

    public boolean isFrenzyItem(class_1799 stack) {
        return stack.method_31574(CanadaItems.DONAIR) || stack.method_31574(CanadaItems.POUTINE) || stack.method_31574(CanadaItems.PIEROGI);
    }

    public boolean isFatigueRefreshItem(class_1799 stack) {
        return stack.method_31574(CanadaItems.MAPLE_SYRUP_BOTTLE);
    }

    public boolean isTemptItem(class_1799 stack) {
        return (this.method_5841().method_12789(CHOP_FATIGUE) > 0 && isFatigueRefreshItem(stack))
            || (this.method_5841().method_12789(CHOP_FRENZY) <= 0 && isFrenzyItem(stack))
            || method_6481(stack);
    }

    @Override
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        return (BeaverEntity)CanadaMod.BEAVER_ENTITY.method_5883(world, class_3730.field_16466);
    }

    @Override
    protected class_3414 method_6011(class_1282 source) {
        return CanadaSounds.SOUND_BEAVER_HURT;
    }

    @Override
    protected class_3414 method_6002() {
        return CanadaSounds.SOUND_BEAVER_DEATH;
    }

    @Nullable
    protected class_3414 method_5994() {
        return CanadaSounds.SOUND_BEAVER_AMBIENT;
    }

    @Override
    public float method_17825() {
        return method_6109() ? 0.5F : 1.0F;
    }

    @Override
    public class_4048 method_55694(class_4050 pose) {
        return method_6109() ? BABY_BASE_DIMENSIONS : super.method_55694(pose);
    }

    private static class BeaverMoveControl extends class_5757 {
        public BeaverMoveControl(class_1308 entity) {
            super(entity, 45, 10, 0.1F, 0.5F, false);
        }
    }

    private static class SwimToRandomPlaceGoal extends class_1378 { 
        public SwimToRandomPlaceGoal(BeaverEntity beaver) {
            super(beaver, 1.0D, 40);
        }
    }

    @Override
    public class_1799 method_31480() {
        return new class_1799(CanadaItems.BEAVER_SPAWN_EGG);
    }

    @Override
    public boolean method_5757() {
        // Same as super but ignoring logs
        // They die too often when bonemealing trees
        if (this.field_5960) {
            return false;
        } else {
            var f = this.method_18377(this.method_18376()).comp_2185() * 0.8F;
            var box = class_238.method_30048(this.method_33571(), (double)f, 1.0E-6, (double)f);
            return class_2338.method_29715(box).anyMatch((pos) -> {
                class_2680 blockState = this.method_37908().method_8320(pos);
                return !blockState.method_26215() && !blockState.method_26164(class_3481.field_15475) && blockState.method_26228(this.method_37908(), pos) && class_259.method_1074(blockState.method_26220(this.method_37908(), pos).method_66507(pos), class_259.method_1078(box), class_247.field_16896);
            });
        }
    }

    public boolean isFrenzied() {
        return this.method_5841().method_12789(CHOP_FRENZY) > 0;
    }

    public boolean isFatigued() {
        return this.method_5841().method_12789(CHOP_FATIGUE) > 0;
    }

    @Override
    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        var itemStack = player.method_5998(hand);

        var didEat = false;
        if (this.isFatigueRefreshItem(itemStack) && this.isFatigued()) {
            didEat = true;
            if (!this.method_37908().field_9236) {
                this.method_5841().method_12778(CHOP_FATIGUE, 0);
            }
        }
        if (this.isFrenzyItem(itemStack) && !this.isFrenzied()) {
            didEat = true;
            if (!this.method_37908().field_9236) {
                this.method_5841().method_12778(CHOP_FRENZY, 20 * 30);
            }
        }

        if (didEat) {
            if (!this.method_37908().field_9236) {
                this.method_6475(player, hand, itemStack);
                this.method_61458();
                return class_1269.field_52422;
            }
            else {
                this.method_37908().method_8406(class_2398.field_11211, this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), 0.0, 0.0, 0.0);
                if (itemStack.method_31574(CanadaItems.MAPLE_SYRUP_BOTTLE)) {
                    this.method_37908().method_55116(this, class_3417.field_20615.comp_349(), class_3419.field_15254, 1f, 1f);
                }
                else {
                    this.method_37908().method_55116(this, CanadaSounds.SOUND_BEAVER_EAT, class_3419.field_15254, 1f, 1f);
                }
                return class_1269.field_5812;
            }
        }

        return super.method_5992(player, hand);
    }

    @Override
    public void method_6078(class_1282 source) {
        setChoppingProgress(-1);
        super.method_6078(source);
    }

    public void setChoppingProgress(int progress) {
        if (choppingTree != null) {
            PlayerLookup.tracking(this).forEach(player -> {
                ServerPlayNetworking.send(player, new BeaverChopTreeEffectPayload(this.method_5628(), progress, choppingTree));
            });            
        }
    }

    public void setChoppingTree(class_2338 pos) {
        this.choppingTree = pos;
    }

    public class_2338 getChoppingTreePos() {
        return choppingTree;
    }

    public void stopChopping() {
        setChoppingProgress(-1);
        setChoppingTree(null);
    }

    public void onChopTree() {
        // Pause for 5 to 10 minutes
        this.method_5841().method_12778(CHOP_FATIGUE, this.field_5974.method_39332(5 * 60 * 20, 10 * 60 * 20));
    }

    public boolean canChopTree() {
        return !this.method_6109() && (this.method_5841().method_12789(CHOP_FATIGUE) <= 0 || isFrenzied());
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);

        nbt.method_10569("chopFatigue", this.method_5841().method_12789(CHOP_FATIGUE));
        nbt.method_10569("chopFrenzy", this.method_5841().method_12789(CHOP_FRENZY));
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);

        this.method_5841().method_12778(CHOP_FATIGUE, nbt.method_10550("chopFatigue").orElse(0));
        this.method_5841().method_12778(CHOP_FRENZY, nbt.method_10550("chopFrenzy").orElse(0));
    }
}
