package xen42.canadamod.gui;

import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5684;
import net.minecraft.class_9334;
import xen42.canadamod.item.ThermosContentsComponent;

import org.apache.commons.lang3.math.Fraction;
import org.jetbrains.annotations.Nullable;

@Environment(EnvType.CLIENT)
public class ThermosTooltipComponent implements class_5684 {
    private static final class_2960 BUNDLE_PROGRESS_BAR_BORDER_TEXTURE = class_2960.method_60656("container/bundle/bundle_progressbar_border");
    private static final class_2960 BUNDLE_PROGRESS_BAR_FILL_TEXTURE = class_2960.method_60656("container/bundle/bundle_progressbar_fill");
    private static final class_2960 BUNDLE_PROGRESS_BAR_FULL_TEXTURE = class_2960.method_60656("container/bundle/bundle_progressbar_full");
    private static final class_2960 BUNDLE_SLOT_HIGHLIGHT_BACK_TEXTURE = class_2960.method_60656("container/bundle/slot_highlight_back");
    private static final class_2960 BUNDLE_SLOT_HIGHLIGHT_FRONT_TEXTURE = class_2960.method_60656("container/bundle/slot_highlight_front");
    private static final class_2960 BUNDLE_SLOT_BACKGROUND_TEXTURE = class_2960.method_60656("container/bundle/slot_background");
    private static final class_2561 BUNDLE_FULL = class_2561.method_43471("item.minecraft.bundle.full");
    private static final class_2561 BUNDLE_EMPTY = class_2561.method_43471("item.minecraft.bundle.empty");
    private static final class_2561 BUNDLE_EMPTY_DESCRIPTION = class_2561.method_43471("item.canadamod.thermos.empty.description");
    private final ThermosContentsComponent thermosContents;

    public ThermosTooltipComponent(ThermosContentsComponent bundleContents) {
        this.thermosContents = bundleContents;
    }

    public int method_32661(class_327 textRenderer) {
        return this.thermosContents.isEmpty() ? getHeightOfEmpty(textRenderer) : this.getHeightOfNonEmpty();
    }

    public int method_32664(class_327 textRenderer) {
        return 96;
    }

    public boolean method_62003() {
        return true;
    }

    private static int getHeightOfEmpty(class_327 textRenderer) {
        return getDescriptionHeight(textRenderer) + 13 + 8;
    }

    private int getHeightOfNonEmpty() {
        return this.getRowsHeight() + 13 + 8;
    }

    private int getRowsHeight() {
        return this.getRows() * 24;
    }

    private int getXMargin(int width) {
        return (width - 96) / 2;
    }

    private int getRows() {
        return class_3532.method_38788(this.getNumVisibleSlots(), 4);
    }

    private int getNumVisibleSlots() {
        return Math.min(12, this.thermosContents.size());
    }

    public void method_32666(class_327 textRenderer, int x, int y, int width, int height, class_332 context) {
        if (this.thermosContents.isEmpty()) {
            this.drawEmptyTooltip(textRenderer, x, y, width, height, context);
        } else {
            this.drawNonEmptyTooltip(textRenderer, x, y, width, height, context);
        }

    }

    private void drawEmptyTooltip(class_327 textRenderer, int x, int y, int width, int height, class_332 context) {
        drawEmptyDescription(x + this.getXMargin(width), y, textRenderer, context);
        this.drawProgressBar(x + this.getXMargin(width), y + getDescriptionHeight(textRenderer) + 4, textRenderer, context);
    }

    private void drawNonEmptyTooltip(class_327 textRenderer, int x, int y, int width, int height, class_332 context) {
        boolean bl = this.thermosContents.size() > 12;
        List<class_1799> list = this.firstStacksInContents(this.thermosContents.getNumberOfStacksShown());
        int i = x + this.getXMargin(width) + 96;
        int j = y + this.getRows() * 24;
        int k = 1;

        for(int l = 1; l <= this.getRows(); ++l) {
            for(int m = 1; m <= 4; ++m) {
            int n = i - m * 24;
            int o = j - l * 24;
            if (shouldDrawExtraItemsCount(bl, m, l)) {
                drawExtraItemsCount(n, o, this.numContentItemsAfter(list), textRenderer, context);
            } else if (shouldDrawItem(list, k)) {
                this.drawItem(k, n, o, list, k, textRenderer, context);
                ++k;
            }
            }
        }

        this.drawSelectedItemTooltip(textRenderer, context, x, y, width);
        this.drawProgressBar(x + this.getXMargin(width), y + this.getRowsHeight() + 4, textRenderer, context);
    }

    private List<class_1799> firstStacksInContents(int numberOfStacksShown) {
        int i = Math.min(this.thermosContents.size(), numberOfStacksShown);
        return this.thermosContents.stream().toList().subList(0, i);
    }

    private static boolean shouldDrawExtraItemsCount(boolean hasMoreItems, int column, int row) {
        return hasMoreItems && column * row == 1;
    }

    private static boolean shouldDrawItem(List<class_1799> items, int itemIndex) {
        return items.size() >= itemIndex;
    }

    private int numContentItemsAfter(List<class_1799> items) {
        return this.thermosContents.stream().skip((long)items.size()).mapToInt(class_1799::method_7947).sum();
    }

    private void drawItem(int index, int x, int y, List<class_1799> stacks, int seed, class_327 textRenderer, class_332 drawContext) {
        int i = stacks.size() - index;
        boolean bl = i == this.thermosContents.getSelectedStackIndex();
        class_1799 itemStack = (class_1799)stacks.get(i);
        if (bl) {
            drawContext.method_52706(class_1921::method_62277, BUNDLE_SLOT_HIGHLIGHT_BACK_TEXTURE, x, y, 24, 24);
        } else {
            drawContext.method_52706(class_1921::method_62277, BUNDLE_SLOT_BACKGROUND_TEXTURE, x, y, 24, 24);
        }

        drawContext.method_51428(itemStack, x + 4, y + 4, seed);
        drawContext.method_51431(textRenderer, itemStack, x + 4, y + 4);
        if (bl) {
            drawContext.method_52706(class_1921::method_62275, BUNDLE_SLOT_HIGHLIGHT_FRONT_TEXTURE, x, y, 24, 24);
        }

    }

    private static void drawExtraItemsCount(int x, int y, int numExtra, class_327 textRenderer, class_332 drawContext) {
        drawContext.method_25300(textRenderer, "+" + numExtra, x + 12, y + 10, 16777215);
    }

    private void drawSelectedItemTooltip(class_327 textRenderer, class_332 drawContext, int x, int y, int width) {
        if (this.thermosContents.hasSelectedStack()) {
            class_1799 itemStack = this.thermosContents.get(this.thermosContents.getSelectedStackIndex());
            class_2561 text = itemStack.method_63015();
            int i = textRenderer.method_30880(text.method_30937());
            int j = x + width / 2 - 12;
            drawContext.method_64235(textRenderer, text, j - i / 2, y - 15, (class_2960)itemStack.method_58694(class_9334.field_54198));
        }

    }

    private void drawProgressBar(int x, int y, class_327 textRenderer, class_332 drawContext) {
        drawContext.method_52706(class_1921::method_62277, this.getProgressBarFillTexture(), x + 1, y, this.getProgressBarFill(), 13);
        drawContext.method_52706(class_1921::method_62277, BUNDLE_PROGRESS_BAR_BORDER_TEXTURE, x, y, 96, 13);
        class_2561 text = this.getProgressBarLabel();
        if (text != null) {
            drawContext.method_27534(textRenderer, text, x + 48, y + 3, 16777215);
        }

    }

    private static void drawEmptyDescription(int x, int y, class_327 textRenderer, class_332 drawContext) {
        drawContext.method_65179(textRenderer, BUNDLE_EMPTY_DESCRIPTION, x, y, 96, 11184810);
    }

    private static int getDescriptionHeight(class_327 textRenderer) {
        int var10000 = textRenderer.method_1728(BUNDLE_EMPTY_DESCRIPTION, 96).size();
        Objects.requireNonNull(textRenderer);
        return var10000 * 9;
    }

    private int getProgressBarFill() {
        return class_3532.method_15340(class_3532.method_59515(this.thermosContents.getOccupancy(), 94), 0, 94);
    }

    private class_2960 getProgressBarFillTexture() {
        return this.thermosContents.getOccupancy().compareTo(Fraction.ONE) >= 0 ? BUNDLE_PROGRESS_BAR_FULL_TEXTURE : BUNDLE_PROGRESS_BAR_FILL_TEXTURE;
    }

    @Nullable
    private class_2561 getProgressBarLabel() {
        if (this.thermosContents.isEmpty()) {
            return BUNDLE_EMPTY;
        } else {
            return this.thermosContents.getOccupancy().compareTo(Fraction.ONE) >= 0 ? BUNDLE_FULL : null;
        }
    }
}
