package xen42.canadamod.mixin;

import java.util.List;
import net.minecraft.class_10124;
import net.minecraft.class_10127;
import net.minecraft.class_10134;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_5712;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xen42.canadamod.item.DurabilityFoodItem;

@Mixin(class_10124.class)
public abstract class ConsumableComponentMixin {
    @Shadow
    public abstract List<class_10134> onConsumeEffects();

    @Shadow
    public abstract class_1839 useAction();

    @Inject(at = @At("HEAD"), method = "finishConsumption", cancellable = true)
    public void finishConsumption(class_1937 world, class_1309 user, class_1799 stack, CallbackInfoReturnable<class_1799> info) {
        if (stack.method_7909() instanceof DurabilityFoodItem) {
            var thisConsumable = (class_10124)(Object)this;

            var random = user.method_59922();
            thisConsumable.method_62843(random, user, stack, 16);
            if (user instanceof class_3222 serverPlayerEntity) {
                serverPlayerEntity.method_7259(class_3468.field_15372.method_14956(stack.method_7909()));
                class_174.field_1198.method_8821(serverPlayerEntity, stack);
            }

            stack.method_62984(class_10127.class).forEach((consumable) -> {
                consumable.method_62831(world, user, stack, thisConsumable);
            });
            if (!world.field_9236) {
                this.onConsumeEffects().forEach((effect) -> {
                    effect.method_62866(world, stack, user);
                });
            }

            user.method_32876(this.useAction() == class_1839.field_8946 ? class_5712.field_28734 : class_5712.field_28735);
            if (!user.method_56992() && user instanceof class_1657 player) {
                stack.method_61653(1, player);
            }
            if (stack.method_7919() >= stack.method_7936() - 1) {
                stack.method_57008(1, user);
            }
            info.setReturnValue(stack);
            info.cancel();
        }
    }
}
