package xen42.canadamod.screen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1729;
import net.minecraft.class_1735;
import net.minecraft.class_1737;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_3218;
import net.minecraft.class_3913;
import net.minecraft.class_3914;
import net.minecraft.class_3919;
import net.minecraft.class_5421;
import net.minecraft.class_8566;
import net.minecraft.class_8786;
import net.minecraft.class_9875;
import xen42.canadamod.CanadaBlocks;
import xen42.canadamod.CanadaMod;
import xen42.canadamod.recipe.CookingPotRecipe;

public class CookingPotScreenHandler extends class_1729 {

    public final static int OUTPUT_SLOT = 0;
    public final static int FUEL_SLOT = 1;
    public final static int CONTAINER_SLOT = 2;    
    public final static int INPUT_SLOTS_START = 3;
    public final static int INPUT_SLOTS_END = 6;

    public static final int INVENTORY_SLOTS_START = 7;
    public static final int INVENTORY_SLOTS_END = 33;
    public static final int HOTBAR_SLOTS_START = 34;
    public static final int HOTBAR_SLOTS_END = 42;

    public static final int MAX_WIDTH_AND_HEIGHT = 2;

    private final class_3913 propertyDelegate;

    public class_1263 inventory;

    public class_3914 context;

    private final class_1657 player;

    private class_1735[] _slots;
    private class_1735 _fuelSlot;
    private class_1735 _containerSlot;
    private class_1735 _outputSlot;

    public List<class_1735> getInputSlots() {
        return Arrays.asList(_slots);
    }

    public class_1735 getFuelSlot() {
        return _fuelSlot;
    }

    public class_1735 getContainerSlot() {
        return _containerSlot;
    }

    public class_1735 getOutputSlot() {
        return _outputSlot;
    }

    public CookingPotScreenHandler(int syncId, class_1661 playerInventory) {
        this(syncId, playerInventory, class_3914.field_17304, null, new class_3919(4));
    }

    public CookingPotScreenHandler(int syncId, class_1661 playerInventory, class_3914 context, class_1263 inventory, class_3913 delegate) {
        super(CanadaMod.COOKING_POT_SCREEN_HANDLER_TYPE, syncId);
        this.inventory = inventory == null ? new CookingPotSimpleInventory(this, 8) : inventory;
        this.context = context;
        this.player = playerInventory.field_7546;
        
        method_17359(this.inventory, 8);
        this.propertyDelegate = delegate;

        _outputSlot = this.method_7621(new OutputSlot(this, this.inventory, OUTPUT_SLOT, 141, 35));
        _fuelSlot = this.method_7621(new FuelSlot(this, this.inventory, FUEL_SLOT, 80, 61));
        _containerSlot = this.method_7621(new ContainerSlot(this, this.inventory, CONTAINER_SLOT, 23, 35));

        _slots = new class_1735[] {
            this.method_7621(new CustomSlot(this, this.inventory, INPUT_SLOTS_START, 71, 8)),
            this.method_7621(new CustomSlot(this, this.inventory, INPUT_SLOTS_START+1, 89, 8)),
            this.method_7621(new CustomSlot(this, this.inventory, INPUT_SLOTS_START+2, 71, 26)),
            this.method_7621(new CustomSlot(this, this.inventory, INPUT_SLOTS_START+3, 89, 26))
        };

        this.method_61624(playerInventory, 8, 84);

        this.method_17360(this.propertyDelegate);
    }

    private int getSlotWithIngredient(class_1856 ingredient) {
        for (int i = 0; i < field_7761.size(); i++) {
            if (class_1856.method_61676(Optional.of(ingredient), this.field_7761.get(i).method_7677())) {
                return i;
            }
        }
        return -1;
    }

    private int[] getSlotsWithIngredient(class_1856 ingredient) {
        var matches = new ArrayList<Integer>();
        for (int i = INVENTORY_SLOTS_START; i < field_7761.size(); i++) {
            if (class_1856.method_61676(Optional.of(ingredient), this.field_7761.get(i).method_7677())) {
                matches.add(i);
            }
        }
        return matches.stream().mapToInt(Integer::intValue).toArray();
    }

    @Override
    public class_9885 method_17697(boolean craftAll, boolean creative, class_8786<?> recipeEntry, class_3218 world, class_1661 inventory) {
        var recipe = (CookingPotRecipe)recipeEntry.comp_1933();

        // Clear stuff
        // If we can't clear, don't show ghost recipe
        this.method_7601(player, CONTAINER_SLOT);
        for (int i = INPUT_SLOTS_START; i <= INPUT_SLOTS_END; i++) {
            if (this.field_7761.get(i).method_7677().method_7960()) {
                continue;
            }
            if (this.method_7601(player, i).method_7960()) {
                return class_1729.class_9885.field_52572;
            }
        }

        var outputSlot = method_7611(OUTPUT_SLOT);
        if (!outputSlot.method_7677().method_7960() && !outputSlot.method_7677().method_31574(recipe.result.method_7909())) {
            this.method_7601(player, OUTPUT_SLOT);
        }

        var bottleSlot = getSlotWithIngredient(class_1856.method_8101(class_1802.field_8469));
        var bowlSlot = getSlotWithIngredient(class_1856.method_8101(class_1802.field_8428));
        var ingredientSlots = new int[recipe.ingredients.size()];
        
        for (int j = 0; j < recipe.ingredients.size(); j++) {
            ingredientSlots[j] = getSlotWithIngredient(recipe.ingredients.get(j));
        }

        if ((recipe.requiresBottle && bottleSlot == -1) || (recipe.requiresBowl && bowlSlot == -1) || Arrays.stream(ingredientSlots).anyMatch(x -> x == -1)) {
            return class_1729.class_9885.field_52573;
        }
        else {
            // Surely theres a better way
            if (recipe.requiresBottle) {
                for (int slot : getSlotsWithIngredient(class_1856.method_8101(class_1802.field_8469))) {
                    this.method_7616(this.field_7761.get(slot).method_7677(), CONTAINER_SLOT, CONTAINER_SLOT + 1, false);
                }
            }
            if (recipe.requiresBowl) {
                for (int slot : getSlotsWithIngredient(class_1856.method_8101(class_1802.field_8428))) {
                    this.method_7616(this.field_7761.get(slot).method_7677(), CONTAINER_SLOT, CONTAINER_SLOT + 1, false);
                }
            }

            var ingredientCounts = recipe.ingredients.stream().collect(Collectors.groupingBy(e -> e, Collectors.counting()));
            int start = INPUT_SLOTS_START;
            for (var entry : ingredientCounts.entrySet()) {
                var ingredient = entry.getKey();
                var count = entry.getValue();

                var slots = getSlotsWithIngredient(ingredient);
                var end = start + (int)(long)count;
                for (int slot : slots) {
                    this.method_7616(this.field_7761.get(slot).method_7677(), start, end, false);
                }
                if (count > 1) {
                    // Equalize them
                    var stacks = IntStream.range(start, end).mapToObj(x -> this.field_7761.get(x)).collect(Collectors.toList());
                    equalizeStacks(stacks);
                }
                start = end;
            }

            return class_1729.class_9885.field_52572;
        }
    }

    public static void equalizeStacks(List<class_1735> slots) {
        var totalItems = slots.stream().mapToInt(slot -> slot.method_7677().method_7947()).sum();
        var numStacks = slots.size();
        var itemsPerStack = totalItems / numStacks;
        var remainder = totalItems % numStacks;
        var item = slots.get(0).method_7677().method_7909();

        for (int i = 0; i < numStacks; i++) {
            int count = itemsPerStack + (i < remainder ? 1 : 0);
            slots.get(i).method_53512(new class_1799(item, count));
        }
    }

    public boolean isCooking() {
        return this.getCookProgress() > 0f;
    }

    public float getFuelProgress() {
        return (float)this.propertyDelegate.method_17390(0) / (float)this.propertyDelegate.method_17390(1); 
    }

    public float getCookProgress() {
        return 1f - ((float)this.propertyDelegate.method_17390(2) / (float)this.propertyDelegate.method_17390(3)); 
    }

    @Override
    public class_5421 method_30264() {
        return class_5421.field_25763; // Return crafting because making a RecipeBookType is impossible.
    }

    @Override
    public void method_7654(class_9875 finder) {
        if (this.inventory instanceof class_1737 recipeInputProvider) {
            recipeInputProvider.method_7683(finder);
        }
    }

    @Override
    public boolean method_7597(class_1657 player) {
        return method_17695(this.context, player, CanadaBlocks.COOKING_POT);
    }

    @Override
    public class_1799 method_7601(class_1657 player, int slot) {
        class_1799 itemStack = class_1799.field_8037;
        class_1735 slotAtIndex = this.field_7761.get(slot);
        if (slotAtIndex != null && slotAtIndex.method_7681() && slotAtIndex.method_7674(player)) {
            class_1799 itemStackAtIndex = slotAtIndex.method_7677();
            itemStack = itemStackAtIndex.method_7972();
            if (slot == OUTPUT_SLOT) {
                itemStackAtIndex.method_7909().method_54465(itemStackAtIndex, player);
                if (!this.method_7616(itemStackAtIndex, INVENTORY_SLOTS_START, HOTBAR_SLOTS_END, true)) {
                    return class_1799.field_8037;
                }

                slotAtIndex.method_7670(itemStackAtIndex, itemStack);
            } else if (slot >= INVENTORY_SLOTS_START && slot < HOTBAR_SLOTS_END) {
                if (isContainer(itemStackAtIndex)) {
                    this.method_7616(itemStackAtIndex, CONTAINER_SLOT, CONTAINER_SLOT + 1, false);
                }
                else if (isFuel(itemStackAtIndex)) {
                    this.method_7616(itemStackAtIndex, FUEL_SLOT, FUEL_SLOT + 1, false);
                }
                else {
                    if (!this.method_7616(itemStackAtIndex, INPUT_SLOTS_START, INVENTORY_SLOTS_START, false)) {
                        if (slot < HOTBAR_SLOTS_START) {
                            if (!this.method_7616(itemStackAtIndex, HOTBAR_SLOTS_START, HOTBAR_SLOTS_END, false)) {
                                return class_1799.field_8037;
                            }
                        } else if (!this.method_7616(itemStackAtIndex, INVENTORY_SLOTS_START, HOTBAR_SLOTS_START, false)) {
                            return class_1799.field_8037;
                        }
                    }
                }
            } else if (!this.method_7616(itemStackAtIndex, INVENTORY_SLOTS_START, HOTBAR_SLOTS_END, false)) {
                return class_1799.field_8037;
            }

            if (itemStackAtIndex.method_7960()) {
                slotAtIndex.method_53512(class_1799.field_8037);
            } else {
                slotAtIndex.method_7668();
            }

            if (itemStackAtIndex.method_7947() == itemStack.method_7947()) {
                return class_1799.field_8037;
            }

            slotAtIndex.method_7667(player, itemStackAtIndex);
            if (slot == OUTPUT_SLOT) {
                player.method_7328(itemStackAtIndex, false);
            }
        }

        return itemStack;
    }

    public boolean isFuel(class_1799 item) {
        return this.player.method_37908().method_61269().method_61752(item);
    }

    public static boolean isContainer(class_1799 item) {
        return item.method_31574(class_1802.field_8428) || item.method_31574(class_1802.field_8469);
    }

    private class CookingPotSimpleInventory extends class_1277 implements class_8566 {
        private class_1703 _screen;

        CookingPotSimpleInventory(CookingPotScreenHandler screen, int size) {
            super(size);
            _screen = screen;
        }

        public void method_5431() {
            _screen.method_7609(this);
            super.method_5431();
        }

        @Override
        public int method_17398() {
            return MAX_WIDTH_AND_HEIGHT;
        }

        @Override
        public int method_17397() {
            return MAX_WIDTH_AND_HEIGHT;
        }
    }

    private class CustomSlot extends class_1735 {
        protected CookingPotScreenHandler _handler;
        public CustomSlot(CookingPotScreenHandler handler, class_1263 inventory, int index, int x, int y) {
            super(inventory, index, x, y);
            _handler = handler;
        }

        @Override
        public void method_7668() {
            super.method_7668();
            _handler.method_7609(_handler.inventory);
            _handler.inventory.method_5431();
        }

        @Override
        public boolean method_7680(class_1799 stack) {
            return !_handler.isContainer(stack);
        }
    }

    private class ContainerSlot extends CustomSlot {
        public ContainerSlot(CookingPotScreenHandler handler, class_1263 inventory, int index, int x, int y) {
            super(handler, inventory, index, x, y);
        }

        @Override
        public boolean method_7680(class_1799 stack) {
            return _handler.isContainer(stack);
        }
    }

    private class OutputSlot extends CustomSlot {
        public OutputSlot(CookingPotScreenHandler handler, class_1263 inventory, int index, int x, int y) {
            super(handler, inventory, index, x, y);
        }

        @Override
        public boolean method_7680(class_1799 stack) {
            return false;
        }
    }

    private class FuelSlot extends CustomSlot {
        public FuelSlot(CookingPotScreenHandler handler, class_1263 inventory, int index, int x, int y) {
            super(handler, inventory, index, x, y);
        }

        @Override
        public boolean method_7680(class_1799 stack) {
            return _handler.isFuel(stack);
        }
    }
}
