/*
 * Decompiled with CFR 0.152.
 */
package pl.pasieniec.pasiWorldGuardAddon;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.association.RegionAssociable;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.flags.registry.FlagRegistry;
import com.sk89q.worldguard.protection.managers.RegionManager;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockFertilizeEvent;
import org.bukkit.event.entity.EntityToggleGlideEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import pl.pasieniec.pasiWorldGuardAddon.Extra.UpdateChecker;
import pl.pasieniec.pasiWorldGuardAddon.bukkit.Metrics;

public class PasiWorldGuardAddon
extends JavaPlugin
implements Listener {
    public static final StateFlag PASI_INTERACT = new StateFlag("pasiinteract", true);
    public static final StateFlag PASI_FEED = new StateFlag("pasifeed", true);
    public static final StateFlag GLIDE = new StateFlag("glide", true);
    public static final StateFlag KEEP_INV = new StateFlag("keep-inventory", false);
    public static final StateFlag KEEP_XP = new StateFlag("keep-xp", false);
    private UpdateChecker updateChecker;
    private static final Set<Material> BLOCKED_INTERACT = new HashSet<Material>(Arrays.asList(Material.OAK_DOOR, Material.IRON_DOOR, Material.SPRUCE_DOOR, Material.BIRCH_DOOR, Material.JUNGLE_DOOR, Material.ACACIA_DOOR, Material.DARK_OAK_DOOR, Material.CHERRY_DOOR, Material.MANGROVE_DOOR, Material.CRIMSON_DOOR, Material.WARPED_DOOR, Material.OAK_TRAPDOOR, Material.IRON_TRAPDOOR, Material.SPRUCE_TRAPDOOR, Material.BIRCH_TRAPDOOR, Material.JUNGLE_TRAPDOOR, Material.ACACIA_TRAPDOOR, Material.DARK_OAK_TRAPDOOR, Material.CHERRY_TRAPDOOR, Material.MANGROVE_TRAPDOOR, Material.CRIMSON_TRAPDOOR, Material.WARPED_TRAPDOOR, Material.OAK_SIGN, Material.SPRUCE_SIGN, Material.BIRCH_SIGN, Material.JUNGLE_SIGN, Material.ACACIA_SIGN, Material.DARK_OAK_SIGN, Material.CHERRY_SIGN, Material.MANGROVE_SIGN, Material.CRIMSON_SIGN, Material.WARPED_SIGN, Material.LEVER, Material.STONE_BUTTON, Material.OAK_BUTTON, Material.SPRUCE_BUTTON, Material.BIRCH_BUTTON, Material.JUNGLE_BUTTON, Material.ACACIA_BUTTON, Material.DARK_OAK_BUTTON, Material.MANGROVE_BUTTON, Material.CHERRY_BUTTON, Material.CRIMSON_BUTTON, Material.WARPED_BUTTON, Material.STONE_PRESSURE_PLATE, Material.LIGHT_WEIGHTED_PRESSURE_PLATE, Material.HEAVY_WEIGHTED_PRESSURE_PLATE, Material.OAK_PRESSURE_PLATE, Material.SPRUCE_PRESSURE_PLATE, Material.BIRCH_PRESSURE_PLATE, Material.JUNGLE_PRESSURE_PLATE, Material.ACACIA_PRESSURE_PLATE, Material.DARK_OAK_PRESSURE_PLATE, Material.MANGROVE_PRESSURE_PLATE, Material.CHERRY_PRESSURE_PLATE, Material.CRIMSON_PRESSURE_PLATE, Material.WARPED_PRESSURE_PLATE));
    private static final Set<EntityType> FEEDABLE_ENTITIES = new HashSet<EntityType>(Arrays.asList(EntityType.COW, EntityType.SHEEP, EntityType.PIG, EntityType.CHICKEN, EntityType.WOLF, EntityType.CAT, EntityType.HORSE, EntityType.RABBIT, EntityType.DONKEY, EntityType.LLAMA, EntityType.MULE, EntityType.FOX, EntityType.PARROT, EntityType.TURTLE));
    private final Map<UUID, List<ItemStack>> savedInventories = new HashMap<UUID, List<ItemStack>>();
    private final Map<UUID, Integer> savedXp = new HashMap<UUID, Integer>();

    public void onLoad() {
        int count = 0;
        try {
            FlagRegistry registry = WorldGuard.getInstance().getFlagRegistry();
            registry.register((Flag)PASI_INTERACT);
            ++count;
            registry.register((Flag)PASI_FEED);
            ++count;
            registry.register((Flag)GLIDE);
            ++count;
            registry.register((Flag)KEEP_INV);
            ++count;
            registry.register((Flag)KEEP_XP);
            this.getLogger().info("\u2705 Flagi zarejestrowane - " + ++count);
        }
        catch (Exception e) {
            this.getLogger().warning("\u274c B\u0142\u0105d rejestracji flag: " + e.getMessage());
        }
    }

    public void onEnable() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getLogger().info("Pasi addon odpalony \ud83d\udd25");
        this.updateChecker = new UpdateChecker(this);
        this.updateChecker.checkForUpdatesOnStartup();
        if (this.updateChecker instanceof Listener) {
            this.getServer().getPluginManager().registerEvents((Listener)this.updateChecker, (Plugin)this);
        }
        int pluginID = 25866;
        Metrics metrics1 = new Metrics((Plugin)this, pluginID);
        int pluginid = 26109;
        Metrics metrics2 = new Metrics((Plugin)this, pluginid);
    }

    private boolean regionHasFlag(Player player, StateFlag flag) {
        RegionManager rm = WorldGuard.getInstance().getPlatform().getRegionContainer().get(BukkitAdapter.adapt((World)player.getWorld()));
        if (rm == null) {
            return false;
        }
        ApplicableRegionSet regionSet = rm.getApplicableRegions(BukkitAdapter.asBlockVector((Location)player.getLocation()));
        return !regionSet.testState((RegionAssociable)WorldGuardPlugin.inst().wrapPlayer(player), new StateFlag[]{flag});
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent event) {
        if (!event.hasBlock()) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block block = event.getClickedBlock();
        Player player = event.getPlayer();
        if (block == null || !BLOCKED_INTERACT.contains(block.getType())) {
            return;
        }
        if (player.hasPermission("pwga.exempt.interact")) {
            return;
        }
        if (this.regionHasFlag(player, PASI_INTERACT)) {
            event.setCancelled(true);
            player.sendMessage("\u00a7cInterakcja z tym obiektem jest zablokowana w tej strefie.");
        }
    }

    @EventHandler
    public void onArmorStandInteract(PlayerInteractAtEntityEvent event) {
        if (!(event.getRightClicked() instanceof ArmorStand)) {
            return;
        }
        Player player = event.getPlayer();
        if (player.hasPermission("pwga.exempt.interact")) {
            return;
        }
        if (this.regionHasFlag(player, PASI_INTERACT)) {
            event.setCancelled(true);
            player.sendMessage("\u00a7cNie mo\u017cesz u\u017cywa\u0107 armor stand\u00f3w w tej strefie.");
        }
    }

    @EventHandler
    public void onFertilize(BlockFertilizeEvent event) {
        Player player = event.getPlayer();
        if (player == null || player.hasPermission("pwga.exempt.interact")) {
            return;
        }
        if (this.regionHasFlag(player, PASI_INTERACT)) {
            event.setCancelled(true);
            player.sendMessage("\u00a7cNie mo\u017cesz u\u017cywa\u0107 m\u0105czki kostnej w tej strefie.");
        }
    }

    @EventHandler
    public void onEntityInteract(PlayerInteractEntityEvent event) {
        Entity entity = event.getRightClicked();
        Player player = event.getPlayer();
        if (!FEEDABLE_ENTITIES.contains(entity.getType())) {
            return;
        }
        if (player.hasPermission("pwga.exempt.feed")) {
            return;
        }
        if (this.regionHasFlag(player, PASI_FEED)) {
            event.setCancelled(true);
            player.sendMessage("\u00a7cNie mo\u017cesz karmi\u0107/interagowa\u0107 z tym zwierzakiem w tej strefie.");
        }
    }

    @EventHandler
    public void onGlide(EntityToggleGlideEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        if (!event.isGliding()) {
            return;
        }
        if (this.regionHasFlag(player, GLIDE)) {
            event.setCancelled(true);
            player.sendMessage("\u00a7cLatanie na elytrze jest zablokowane w tej strefie.");
        }
    }

    @EventHandler
    public void onDeath(PlayerDeathEvent event) {
        boolean keepXp;
        Player player = event.getEntity();
        boolean keepInv = !this.regionHasFlag(player, KEEP_INV);
        boolean bl = keepXp = !this.regionHasFlag(player, KEEP_XP);
        if (keepInv) {
            this.savedInventories.put(player.getUniqueId(), Arrays.asList(player.getInventory().getContents()));
            event.getDrops().clear();
        }
        if (keepXp) {
            this.savedXp.put(player.getUniqueId(), player.getTotalExperience());
            event.setKeepLevel(true);
            event.setDroppedExp(0);
        }
    }

    @EventHandler
    public void onRespawn(PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        Bukkit.getScheduler().runTaskLater((Plugin)this, () -> {
            if (this.savedInventories.containsKey(uuid)) {
                player.getInventory().setContents(this.savedInventories.remove(uuid).toArray(new ItemStack[0]));
            }
            if (this.savedXp.containsKey(uuid)) {
                player.setTotalExperience(this.savedXp.remove(uuid).intValue());
            }
        }, 2L);
    }
}

