/*
 * Decompiled with CFR 0.152.
 */
package pl.pasieniec.pasiWorldGuardAddon.Extra;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class UpdateChecker
implements Listener {
    private final JavaPlugin plugin;
    public boolean updateAvailable = false;
    public String newVersion = null;
    private static final String MODRINTH_PROJECT_ID = "pOGWLtU9";
    private static final String MODRINTH_API_URL = "https://api.modrinth.com/v2/project/pOGWLtU9/version";

    public UpdateChecker(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public void checkForUpdatesOnStartup() {
        new BukkitRunnable(){

            public void run() {
                try {
                    String line;
                    HttpURLConnection connection = (HttpURLConnection)new URL(UpdateChecker.MODRINTH_API_URL).openConnection();
                    connection.setRequestMethod("GET");
                    connection.setRequestProperty("Accept", "application/json");
                    int responseCode = connection.getResponseCode();
                    if (responseCode != 200) {
                        UpdateChecker.this.plugin.getLogger().warning("Niepoprawny kod odpowiedzi API: " + responseCode);
                        return;
                    }
                    BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                    StringBuilder response = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        response.append(line);
                    }
                    reader.close();
                    UpdateChecker.this.newVersion = UpdateChecker.this.parseVersionFromResponse(response.toString());
                    String currentVersion = UpdateChecker.this.plugin.getDescription().getVersion();
                    if (UpdateChecker.this.newVersion != null && UpdateChecker.this.isNewerVersion(currentVersion, UpdateChecker.this.newVersion)) {
                        UpdateChecker.this.updateAvailable = true;
                        UpdateChecker.this.plugin.getLogger().info("Dostepna nowa wersja: " + UpdateChecker.this.newVersion);
                    } else {
                        UpdateChecker.this.plugin.getLogger().info("Plugin jest aktualny. Wersja: " + currentVersion);
                    }
                }
                catch (Exception e) {
                    UpdateChecker.this.plugin.getLogger().warning("Nie udalo si\u0119 sprawdzic dostepnosci aktualizacji: " + e.getMessage());
                }
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (player.hasPermission("pwga.updatenotify") && this.updateAvailable) {
            String currentVersion = this.plugin.getDescription().getVersion();
            String line1 = ChatColor.translateAlternateColorCodes((char)'&', (String)"&b\u0274\u1d0f\u1d21\u1d00 \u1d21\u1d07\u0280\u0455\u1d0a\u1d00 &n\u1d18\u1d00\u0455\u026a\u1d21\u1d0f\u0280\u029f\u1d05\u0262\u1d1c\u1d00\u0280\u1d05\u1d00\u1d05\u1d05\u1d0f\u0274&r &b\u1d05\u1d0f\u0455\u1d1b\u1d07\u1d18\u0274\u1d00 \u0274\u1d00 \u1d0d\u1d0f\u1d05\u0280\u026a\u0274\u1d1b\u029c!");
            String line2 = ChatColor.translateAlternateColorCodes((char)'&', (String)"&e\u1d18\u1d0f\u0299\u026a\u1d07\u0280\u1d22 \u1d0a\u1d00 \u1d1b\u1d1c\u1d1b\u1d00\u1d0a: &3https://modrinth.com/plugin/pasiworldguardaddon");
            String line3 = ChatColor.translateAlternateColorCodes((char)'&', (String)"");
            String line4 = ChatColor.translateAlternateColorCodes((char)'&', (String)("&7\u1d1b\u1d21\u1d0f\u1d0a\u1d00 \u1d21\u1d07\u0280\u0455\u1d0a\u1d00: &4" + currentVersion + " &7\u0274\u1d0f\u1d21\u1d00 \u1d21\u1d07\u0280\u0455\u1d0a\u1d00: &a" + this.newVersion));
            player.sendMessage(line1);
            player.sendMessage(line2);
            player.sendMessage(line3);
            player.sendMessage(line4);
        }
    }

    private String parseVersionFromResponse(String response) {
        try {
            JsonObject firstVersion = JsonParser.parseString((String)response).getAsJsonArray().get(0).getAsJsonObject();
            return firstVersion.get("version_number").getAsString();
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Blad podczas parsowania odpowiedzi API: " + e.getMessage());
            return null;
        }
    }

    private boolean isNewerVersion(String current, String latest) {
        String[] currentParts = current.split("\\.");
        String[] latestParts = latest.split("\\.");
        int length = Math.max(currentParts.length, latestParts.length);
        for (int i = 0; i < length; ++i) {
            int latestPart;
            int currentPart = i < currentParts.length ? Integer.parseInt(currentParts[i]) : 0;
            int n = latestPart = i < latestParts.length ? Integer.parseInt(latestParts[i]) : 0;
            if (latestPart > currentPart) {
                return true;
            }
            if (latestPart >= currentPart) continue;
            return false;
        }
        return false;
    }
}

