/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.client.core.handler;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.psi.common.core.handler.PsiSoundHandler;
import vazkii.psi.common.lib.LibResources;

@EventBusSubscriber(modid="psi", value={Dist.CLIENT})
public class BookSoundHandler {
    private static final int[] SECRET_CODE = new int[]{81, 85, 65, 84, 49, 48, 50, 52};
    private static int nextLetter = 0;
    private static int bookTime = 0;

    private static boolean isBookOpen() {
        return Objects.equals(PatchouliAPI.get().getOpenBookGui(), LibResources.PATCHOULI_BOOK);
    }

    @SubscribeEvent
    public static void clientTick(ClientTickEvent.Pre evt) {
        if (bookTime > 0) {
            --bookTime;
        }
        if (!BookSoundHandler.isBookOpen()) {
            nextLetter = 0;
        }
    }

    @SubscribeEvent
    public static void handleInput(InputEvent.Key evt) {
        Minecraft mc = Minecraft.getInstance();
        if (evt.getModifiers() == 0 && evt.getAction() == 1 && BookSoundHandler.isBookOpen()) {
            if (bookTime == 0 && evt.getKey() == SECRET_CODE[nextLetter]) {
                if (++nextLetter >= SECRET_CODE.length) {
                    mc.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)PsiSoundHandler.book, (float)1.0f));
                    nextLetter = 0;
                    bookTime = 320;
                }
            } else {
                nextLetter = 0;
            }
        }
    }
}

