/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.client.core.handler;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.common.NeoForge;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.cad.ICAD;
import vazkii.psi.api.cad.IPsiBarDisplay;
import vazkii.psi.api.cad.ISocketable;
import vazkii.psi.api.gui.PsiHudElementType;
import vazkii.psi.api.gui.RenderPsiHudEvent;
import vazkii.psi.api.internal.PsiRenderHelper;
import vazkii.psi.client.core.handler.ShaderHandler;
import vazkii.psi.common.core.handler.ConfigHandler;
import vazkii.psi.common.core.handler.PlayerDataHandler;
import vazkii.psi.common.item.base.IHUDItem;

@EventBusSubscriber(modid="psi", value={Dist.CLIENT})
public final class HUDHandler {
    public static final LayeredDraw.Layer SOCKETABLE_EQUIPPED_NAME = (graphics, deltatracker) -> {
        if (!((RenderPsiHudEvent)NeoForge.EVENT_BUS.post((Event)new RenderPsiHudEvent(PsiHudElementType.SOCKETABLE_EQUIPPED_NAME))).isCanceled()) {
            HUDHandler.renderSocketableEquippedName(graphics, deltatracker);
        }
    };
    public static final LayeredDraw.Layer HUD_ITEM = (graphics, deltatracker) -> {
        if (!((RenderPsiHudEvent)NeoForge.EVENT_BUS.post((Event)new RenderPsiHudEvent(PsiHudElementType.HUD_ITEM))).isCanceled()) {
            HUDHandler.renderHUDItem(graphics, deltatracker);
        }
    };
    private static final ResourceLocation psiBar = ResourceLocation.parse((String)"psi:textures/gui/psi_bar.png");
    private static final ResourceLocation psiBarMask = ResourceLocation.parse((String)"psi:textures/gui/psi_bar_mask.png");
    private static final ResourceLocation psiBarShatter = ResourceLocation.parse((String)"psi:textures/gui/psi_bar_shatter.png");
    private static final int maxRemainingTicks = 30;
    private static boolean registeredMask = false;
    public static final LayeredDraw.Layer PSI_BAR = (graphics, deltatracker) -> {
        if (!((RenderPsiHudEvent)NeoForge.EVENT_BUS.post((Event)new RenderPsiHudEvent(PsiHudElementType.PSI_BAR))).isCanceled()) {
            HUDHandler.drawPsiBar(graphics, deltatracker);
        }
    };
    private static ItemStack remainingDisplayStack;
    private static int remainingTime;
    private static int remainingCount;
    public static final LayeredDraw.Layer REMAINING_ITEMS;

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void register(RegisterGuiLayersEvent event) {
        event.registerAboveAll(PsiAPI.location("psi_bar"), PSI_BAR);
        event.registerAboveAll(PsiAPI.location("socketable_equipped_name"), SOCKETABLE_EQUIPPED_NAME);
        event.registerAboveAll(PsiAPI.location("remaining_items"), REMAINING_ITEMS);
        event.registerAboveAll(PsiAPI.location("hud_item"), HUD_ITEM);
    }

    public static void tick() {
        if (remainingTime < 0) {
            return;
        }
        --remainingTime;
    }

    private static boolean showsBar(PlayerDataHandler.PlayerData data, ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        IPsiBarDisplay display = (IPsiBarDisplay)stack.getCapability(PsiAPI.PSI_BAR_DISPLAY_CAPABILITY);
        if (display != null) {
            return display.shouldShow(data);
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void drawPsiBar(GuiGraphics graphics, DeltaTracker deltatracker) {
        Minecraft mc = Minecraft.getInstance();
        ItemStack cadStack = PsiAPI.getPlayerCAD((Player)mc.player);
        if (cadStack.isEmpty()) {
            return;
        }
        ICAD cad = (ICAD)cadStack.getItem();
        PlayerDataHandler.PlayerData data = PlayerDataHandler.get((Player)mc.player);
        int totalPsi = data.getTotalPsi();
        int currPsi = data.getAvailablePsi();
        if (((Boolean)ConfigHandler.CLIENT.contextSensitiveBar.get()).booleanValue() && currPsi == totalPsi && !HUDHandler.showsBar(data, mc.player.getMainHandItem()) && !HUDHandler.showsBar(data, mc.player.getOffhandItem())) {
            return;
        }
        graphics.pose().pushPose();
        boolean right = (Boolean)ConfigHandler.CLIENT.psiBarOnRight.get();
        int pad = 3;
        int width = 32;
        int height = 140;
        int x = -pad;
        if (right) {
            x = graphics.guiWidth() + pad - width;
        }
        int y = graphics.guiHeight() / 2 - height / 2;
        if (!registeredMask) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)psiBarMask);
            RenderSystem.setShaderTexture((int)1, (ResourceLocation)psiBarShatter);
            registeredMask = true;
        }
        RenderSystem.enableBlend();
        graphics.blit(psiBar, x, y, 0.0f, 0.0f, width, height, 64, 256);
        x += 8;
        y += 26;
        width = 16;
        height = 106;
        float r = 0.6f;
        float g = 0.65f;
        float b = 1.0f;
        if (data.isOverflowed()) {
            r = 1.0f;
            g = 0.6f;
            b = 0.6f;
        }
        int origHeight = height;
        int origY = y;
        int v = 0;
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        for (PlayerDataHandler.PlayerData.Deduction d : data.deductions) {
            float a = d.getPercentile(deltatracker.getGameTimeDeltaPartialTick(false));
            RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
            height = (int)Math.ceil((double)origHeight * (double)d.deduct / (double)totalPsi);
            int effHeight = (int)((double)origHeight * (double)d.current / (double)totalPsi);
            v = origHeight - effHeight;
            y = origY + v;
            HUDHandler.usePsiBarShader(a, d.shatter, data.overflowed);
            graphics.blit(psiBar, x, y, 32.0f, (float)v, width, height, 64, 256);
        }
        float textY = origY;
        if (totalPsi > 0) {
            height = (int)((double)origHeight * (double)data.availablePsi / (double)totalPsi);
            v = origHeight - height;
            y = origY + v;
            if (data.availablePsi != data.lastAvailablePsi) {
                float textHeight = (float)((double)origHeight * ((double)((float)data.availablePsi * deltatracker.getGameTimeDeltaPartialTick(false)) + (double)data.lastAvailablePsi * (1.0 - (double)deltatracker.getGameTimeDeltaPartialTick(false))) / (double)totalPsi);
                textY = (float)origY + ((float)origHeight - textHeight);
            } else {
                textY = y;
            }
        } else {
            height = 0;
        }
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)1.0f);
        HUDHandler.usePsiBarShader(1.0f, false, data.overflowed);
        graphics.blit(psiBar, x, y, 32.0f, (float)v, width, height, 64, 256);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.pose().pushPose();
        graphics.pose().translate(0.0f, textY, 0.0f);
        width = 44;
        height = 3;
        int storedPsi = cad.getStoredPsi(cadStack);
        String s1 = storedPsi == -1 ? "\u221e" : "" + data.availablePsi;
        String s2 = "" + storedPsi;
        int offBar = 22;
        int offStr1 = 7 + mc.font.width(s1);
        int offStr2 = 7 + mc.font.width(s2);
        if (!right) {
            offBar = 6;
            offStr1 = -23;
            offStr2 = -23;
        }
        int color = cad.getSpellColor(cadStack);
        RenderSystem.setShaderColor((float)((float)PsiRenderHelper.r(color) / 255.0f), (float)((float)PsiRenderHelper.g(color) / 255.0f), (float)((float)PsiRenderHelper.b(color) / 255.0f), (float)1.0f);
        graphics.blit(psiBar, x - offBar, -2, 0.0f, 140.0f, width, height, 64, 256);
        graphics.drawString(mc.font, s1, x - offStr1, -11, 0xFFFFFF, true);
        graphics.pose().popPose();
        if (storedPsi != -1) {
            graphics.pose().pushPose();
            graphics.pose().translate(0.0f, Math.max(textY + 3.0f, (float)(origY + 100)), 0.0f);
            graphics.drawString(mc.font, s2, x - offStr2, 0, 0xFFFFFF, true);
            graphics.pose().popPose();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        graphics.pose().popPose();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void renderSocketableEquippedName(GuiGraphics graphics, DeltaTracker deltatracker) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null || mc.gui.toolHighlightTimer - 10 <= 0) {
            return;
        }
        ItemStack stack = mc.player.getItemInHand(InteractionHand.MAIN_HAND);
        if (!ISocketable.isSocketable(stack)) {
            return;
        }
        String name = ISocketable.getSocketedItemName(stack, "").getString();
        if (stack.isEmpty() || name.trim().isEmpty()) {
            return;
        }
        ISocketable socketable = ISocketable.socketable(stack);
        ItemStack bullet = socketable.getSelectedBullet();
        int ticks = mc.gui.toolHighlightTimer - 10;
        int alpha = Math.min(255, (int)(((float)ticks - deltatracker.getGameTimeDeltaPartialTick(false)) * 256.0f / 10.0f));
        int color = -15481345 + (alpha << 24);
        int x = graphics.guiWidth() / 2 - mc.font.width(name) / 2;
        int y = graphics.guiHeight() - 71;
        int w = mc.font.width(name);
        if (mc.player.isCreative()) {
            y += 14;
        }
        graphics.drawString(mc.font, name, x, y, color, true);
        graphics.pose().pushPose();
        graphics.pose().translate((float)(x + w), (float)(y - 6), 0.0f);
        graphics.pose().scale((float)alpha / 255.0f, 1.0f, 1.0f);
        graphics.renderFakeItem(bullet, 0, 0);
        graphics.pose().popPose();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void renderRemainingItems(GuiGraphics graphics, DeltaTracker deltatracker) {
        if (remainingTime <= 0 || remainingDisplayStack.isEmpty()) {
            return;
        }
        int pos = 30 - remainingTime;
        Minecraft mc = Minecraft.getInstance();
        int remainingLeaveTicks = 20;
        int x = graphics.guiWidth() / 2 + 10 + Math.max(0, pos - remainingLeaveTicks);
        int y = graphics.guiHeight() / 2;
        int start = 30 - remainingLeaveTicks;
        float alpha = (float)remainingTime + deltatracker.getGameTimeDeltaPartialTick(false) > (float)start ? 1.0f : ((float)remainingTime + deltatracker.getGameTimeDeltaPartialTick(false)) / (float)start;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        int xp = x + (int)(16.0f * (1.0f - alpha));
        graphics.pose().pushPose();
        graphics.pose().translate((float)xp, (float)y, 0.0f);
        graphics.pose().scale(alpha, 1.0f, 1.0f);
        graphics.renderFakeItem(remainingDisplayStack, 0, 0);
        graphics.pose().scale(1.0f / alpha, 1.0f, 1.0f);
        graphics.pose().translate((float)(-xp), (float)(-y), 0.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Object text = remainingDisplayStack.getHoverName().plainCopy().withStyle(ChatFormatting.GREEN).getString();
        if (remainingCount >= 0) {
            int max = remainingDisplayStack.getMaxStackSize();
            int stacks = remainingCount / max;
            int rem = remainingCount % max;
            text = stacks == 0 ? "" + remainingCount : remainingCount + " (" + String.valueOf(ChatFormatting.AQUA) + stacks + String.valueOf(ChatFormatting.RESET) + "*" + String.valueOf(ChatFormatting.GRAY) + max + String.valueOf(ChatFormatting.RESET) + "+" + String.valueOf(ChatFormatting.YELLOW) + rem + String.valueOf(ChatFormatting.RESET) + ")";
        } else if (remainingCount == -1) {
            text = "\u221e";
        }
        int color = 0xFFFFFF | (int)(alpha * 255.0f) << 24;
        graphics.drawString(mc.font, (String)text, x + 20, y + 6, color, true);
        graphics.pose().popPose();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void renderHUDItem(GuiGraphics graphics, DeltaTracker deltatracker) {
        IHUDItem hudItem;
        Item item;
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        ItemStack stack = mc.player.getMainHandItem();
        if (!stack.isEmpty() && (item = stack.getItem()) instanceof IHUDItem) {
            hudItem = (IHUDItem)item;
            hudItem.drawHUD(graphics, deltatracker.getGameTimeDeltaPartialTick(false), graphics.guiWidth(), graphics.guiHeight(), stack);
        }
        if (!(stack = mc.player.getOffhandItem()).isEmpty() && (item = stack.getItem()) instanceof IHUDItem) {
            hudItem = (IHUDItem)item;
            hudItem.drawHUD(graphics, deltatracker.getGameTimeDeltaPartialTick(false), graphics.guiWidth(), graphics.guiHeight(), stack);
        }
    }

    public static void setRemaining(ItemStack stack, int count) {
        remainingDisplayStack = stack;
        remainingCount = count;
        remainingTime = stack.isEmpty() ? 0 : 30;
    }

    public static void setRemaining(Player player, ItemStack displayStack, Pattern pattern) {
        int count = 0;
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack stack = player.getInventory().getItem(i);
            if (stack.isEmpty() || !(pattern == null ? ItemStack.isSameItem((ItemStack)displayStack, (ItemStack)stack) : pattern.matcher(stack.getDescriptionId()).find())) continue;
            count += stack.getCount();
        }
        HUDHandler.setRemaining(displayStack, count);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void usePsiBarShader(float percentile, boolean shatter, boolean overflowed) {
        ShaderInstance psiBarShader = ShaderHandler.getPsiBarShader();
        RenderSystem.setShader(ShaderHandler::getPsiBarShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)psiBar);
        RenderSystem.setShaderTexture((int)1, (ResourceLocation)(shatter ? psiBarShatter : psiBarMask));
        psiBarShader.safeGetUniform("GameTime").set(RenderSystem.getShaderGameTime());
        psiBarShader.safeGetUniform("PsiBarPercentile").set(percentile);
        psiBarShader.safeGetUniform("PsiBarOverflowed").set(overflowed ? 1 : 0);
    }

    static {
        REMAINING_ITEMS = (graphics, deltatracker) -> {
            if (!((RenderPsiHudEvent)NeoForge.EVENT_BUS.post((Event)new RenderPsiHudEvent(PsiHudElementType.REMAINING_ITEMS))).isCanceled()) {
                HUDHandler.renderRemainingItems(graphics, deltatracker);
            }
        };
    }
}

