/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.client.fx;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import vazkii.psi.client.fx.WispParticleData;

@OnlyIn(value=Dist.CLIENT)
public class FXWisp
extends TextureSheetParticle {
    private static final ParticleRenderType NORMAL_RENDER = new ParticleRenderType(){

        public BufferBuilder begin(@NotNull Tesselator tessellator, @NotNull TextureManager textureManager) {
            return FXWisp.beginRenderCommon(tessellator, textureManager);
        }

        public String toString() {
            return "psi:wisp";
        }
    };
    private final float moteParticleScale;
    private final int moteHalfLife;

    public FXWisp(ClientLevel world, double d, double d1, double d2, double xSpeed, double ySpeed, double zSpeed, float size, float red, float green, float blue, float maxAgeMul) {
        super(world, d, d1, d2, 0.0, 0.0, 0.0);
        this.xd = xSpeed;
        this.yd = ySpeed;
        this.zd = zSpeed;
        this.rCol = red;
        this.gCol = green;
        this.bCol = blue;
        this.alpha = 0.375f;
        this.gravity = 0.0f;
        this.moteParticleScale = this.quadSize = (this.random.nextFloat() * 0.5f + 0.5f) * 2.0f * size;
        this.lifetime = (int)(28.0 / (Math.random() * 0.3 + 0.7) * (double)maxAgeMul);
        this.moteHalfLife = this.lifetime / 2;
        this.setSize(0.01f, 0.01f);
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.hasPhysics = true;
    }

    private static BufferBuilder beginRenderCommon(Tesselator tessellator, TextureManager textureManager) {
        Minecraft.getInstance().gameRenderer.lightTexture().turnOnLightLayer();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)1);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.LOCATION_PARTICLES);
        AbstractTexture tex = textureManager.getTexture(TextureAtlas.LOCATION_PARTICLES);
        tex.setFilter(true, false);
        return tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.PARTICLE);
    }

    public float getQuadSize(float scaleFactor) {
        float ageScale = (float)this.age / (float)this.moteHalfLife;
        if (ageScale > 1.0f) {
            ageScale = 2.0f - ageScale;
        }
        this.quadSize = this.moteParticleScale * ageScale * 0.5f;
        return this.quadSize;
    }

    protected int getLightColor(float partialTicks) {
        return 0xF000F0;
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return NORMAL_RENDER;
    }

    public void tick() {
        if (this.age++ >= this.lifetime) {
            this.remove();
            return;
        }
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.yd -= 0.04 * (double)this.gravity;
        this.move(this.xd, this.yd, this.zd);
        this.xd *= (double)0.98f;
        this.yd *= (double)0.98f;
        this.zd *= (double)0.98f;
    }

    public static class Factory
    implements ParticleProvider<WispParticleData> {
        private final SpriteSet sprite;

        public Factory(SpriteSet sprite) {
            this.sprite = sprite;
        }

        public TextureSheetParticle createParticle(WispParticleData data, @NotNull ClientLevel world, double x, double y, double z, double mx, double my, double mz) {
            FXWisp ret = new FXWisp(world, x, y, z, mx, my, mz, data.size(), data.r(), data.g(), data.b(), data.maxAgeMul());
            ret.pickSprite(this.sprite);
            return ret;
        }
    }
}

