/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.client.gui;

import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.glfw.GLFW;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.cad.ISocketable;
import vazkii.psi.api.cad.ISocketableController;
import vazkii.psi.api.internal.PsiRenderHelper;
import vazkii.psi.client.core.handler.KeybindHandler;
import vazkii.psi.common.Psi;
import vazkii.psi.common.core.handler.PlayerDataHandler;
import vazkii.psi.common.network.MessageRegister;
import vazkii.psi.common.network.message.MessageChangeControllerSlot;
import vazkii.psi.common.network.message.MessageChangeSocketableSlot;

public class GuiSocketSelect
extends Screen {
    final Minecraft mc = Minecraft.getInstance();
    float timeIn = 0.0f;
    int slotSelected = -1;
    ItemStack controllerStack = ItemStack.EMPTY;
    ISocketableController controller;
    ItemStack[] controlledStacks;
    int controlSlot;
    ItemStack socketableStack = ItemStack.EMPTY;
    ISocketable socketable;
    List<Integer> slots;
    List<ResourceLocation> signs;

    public GuiSocketSelect(ItemStack stack) {
        super((Component)Component.empty());
        if (ISocketable.isSocketable(stack)) {
            this.setSocketable(stack);
        } else if (stack.getItem() instanceof ISocketableController) {
            this.controllerStack = stack;
            this.controller = (ISocketableController)stack.getItem();
            this.controlledStacks = this.controller.getControlledStacks((Player)this.mc.player, stack);
            this.controlSlot = this.controller.getDefaultControlSlot(this.controllerStack);
            if (this.controlSlot >= this.controlledStacks.length) {
                this.controlSlot = 0;
            }
            this.setSocketable(this.controlledStacks.length == 0 ? ItemStack.EMPTY : this.controlledStacks[this.controlSlot]);
        }
    }

    private static double mouseAngle(int x, int y, int mx, int my) {
        return (Mth.atan2((double)(my - y), (double)(mx - x)) + Math.PI * 2) % (Math.PI * 2);
    }

    public void setSocketable(ItemStack stack) {
        if (stack.isEmpty()) {
            this.slots = new ArrayList<Integer>();
            return;
        }
        this.socketableStack = stack;
        this.socketable = ISocketable.socketable(stack);
        this.slots = this.socketable.getRadialMenuSlots();
        this.signs = this.socketable.getRadialMenuIcons();
    }

    public void render(@NotNull GuiGraphics graphics, int mx, int my, float delta) {
        super.render(graphics, mx, my, delta);
        this.timeIn += delta;
        int x = this.width / 2;
        int y = this.height / 2;
        int maxRadius = 80;
        double angle = GuiSocketSelect.mouseAngle(x, y, mx, my);
        int segments = this.slots.size();
        float step = (float)Math.PI / 180;
        float degPer = (float)Math.PI * 2 / (float)segments;
        ItemStack cadStack = PsiAPI.getPlayerCAD((Player)Minecraft.getInstance().player);
        this.slotSelected = -1;
        Tesselator tess = Tesselator.getInstance();
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        if (segments != 0) {
            BufferBuilder buf = tess.begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_COLOR);
            for (int seg = 0; seg < segments; ++seg) {
                boolean mouseInSector = (double)(degPer * (float)seg) < angle && angle < (double)(degPer * (float)(seg + 1));
                float radius = Math.max(0.0f, Math.min((this.timeIn - (float)seg * 6.0f / (float)segments) * 40.0f, (float)maxRadius));
                if (mouseInSector || seg == this.socketable.getSelectedSlot()) {
                    radius *= 1.025f;
                }
                int gs = 64;
                if (seg % 2 == 0) {
                    gs += 25;
                }
                int r = gs;
                int g = gs;
                int b = gs;
                int a = 102;
                if (seg == 0) {
                    buf.addVertex((float)x, (float)y, 0.0f).setColor(r, g, b, a);
                }
                if (mouseInSector) {
                    this.slotSelected = seg;
                    if (!cadStack.isEmpty()) {
                        int color = Psi.proxy.getColorForCAD(cadStack);
                        r = PsiRenderHelper.r(color);
                        g = PsiRenderHelper.g(color);
                        b = PsiRenderHelper.b(color);
                    } else {
                        b = 255;
                        g = 255;
                        r = 255;
                    }
                } else if (seg == this.socketable.getSelectedSlot()) {
                    if (!cadStack.isEmpty()) {
                        int color = Psi.proxy.getColorForCAD(cadStack);
                        r = 255 - PsiRenderHelper.r(color);
                        g = 255 - PsiRenderHelper.g(color);
                        b = 255 - PsiRenderHelper.b(color);
                    } else {
                        r = 0;
                        g = 255;
                        b = 0;
                    }
                }
                for (float i = 0.0f; i < degPer + step / 2.0f; i += step) {
                    float rad = i + (float)seg * degPer;
                    float xp = (float)x + Mth.cos((float)rad) * radius;
                    float yp = (float)y + Mth.sin((float)rad) * radius;
                    if (i == 0.0f) {
                        buf.addVertex(xp, yp, 0.0f).setColor(r, g, b, a);
                    }
                    buf.addVertex(xp, yp, 0.0f).setColor(r, g, b, a);
                }
            }
            BufferUploader.drawWithShader((MeshData)buf.buildOrThrow());
        }
        for (int seg = 0; seg < segments; ++seg) {
            boolean mouseInSector = (double)(degPer * (float)seg) < angle && angle < (double)(degPer * (float)(seg + 1));
            float radius = Math.max(0.0f, Math.min((this.timeIn - (float)seg * 6.0f / (float)segments) * 40.0f, (float)maxRadius));
            if (mouseInSector || seg == this.socketable.getSelectedSlot()) {
                radius *= 1.025f;
            }
            float rad = ((float)seg + 0.5f) * degPer;
            float xp = (float)x + Mth.cos((float)rad) * radius;
            float yp = (float)y + Mth.sin((float)rad) * radius;
            ItemStack stack = this.socketable.getBulletInSocket(seg);
            if (stack.isEmpty()) continue;
            float xsp = xp - 4.0f;
            float ysp = yp;
            String name = String.valueOf(mouseInSector ? ChatFormatting.UNDERLINE : ChatFormatting.RESET) + stack.getHoverName().getString();
            int width = this.font.width(name);
            double mod = 0.6;
            int xdp = (int)((double)(xp - (float)x) * mod + (double)x);
            int ydp = (int)((double)(yp - (float)y) * mod + (double)y);
            graphics.renderFakeItem(stack, xdp - 8, ydp - 8);
            if (xsp < (float)x) {
                xsp -= (float)(width - 8);
            }
            if (ysp < (float)y) {
                ysp -= 9.0f;
            }
            graphics.drawString(this.font, name, xsp, ysp, 0xFFFFFF, true);
            if (seg == this.socketable.getSelectedSlot()) {
                int color = 65280;
                if (!cadStack.isEmpty()) {
                    color = 0xFF0000 - Psi.proxy.getColorForCAD(cadStack);
                }
                String string = I18n.get((String)"psimisc.selected", (Object[])new Object[0]);
                float f = xsp + (float)width / 4.0f;
                Objects.requireNonNull(this.font);
                graphics.drawString(this.font, string, f, ysp + 9.0f, color, true);
            }
            mod = 0.8;
            xdp = (int)((double)(xp - (float)x) * mod + (double)x);
            ydp = (int)((double)(yp - (float)y) * mod + (double)y);
            graphics.blit(this.signs.get(seg), xdp - 8, ydp - 8, 0.0f, 0.0f, 16, 16, 16, 16);
        }
        float shift = Math.min(5.0f, this.timeIn) / 5.0f;
        float scale = 3.0f * shift;
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        if (this.controlledStacks != null && this.controlledStacks.length > 0) {
            int xs = this.width / 2 - 18 * this.controlledStacks.length / 2 + 1;
            int ys = this.height / 2;
            for (int i = 0; i < this.controlledStacks.length; ++i) {
                float yoff = 20.0f + (float)maxRadius;
                if (i == this.controlSlot) {
                    yoff += 5.0f;
                }
                ItemStack stack = this.controlledStacks[i];
                int rx = xs + i * 18;
                float ry = (float)ys + -yoff * shift;
                graphics.renderFakeItem(stack, rx, (int)ry);
            }
        }
        if (!this.socketableStack.isEmpty()) {
            graphics.pose().pushPose();
            graphics.pose().scale(scale, scale, scale);
            graphics.renderFakeItem(this.socketableStack, (int)((float)x / scale) - 8, (int)((float)y / scale) - 8);
            graphics.pose().popPose();
        }
        RenderSystem.disableBlend();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        if (!this.controllerStack.isEmpty() && this.controlledStacks.length > 0) {
            if (mouseButton == 0) {
                ++this.controlSlot;
                if (this.controlSlot >= this.controlledStacks.length) {
                    this.controlSlot = 0;
                }
            } else if (mouseButton == 1) {
                --this.controlSlot;
                if (this.controlSlot < 0) {
                    this.controlSlot = this.controlledStacks.length - 1;
                }
            }
            this.setSocketable(this.controlledStacks[this.controlSlot]);
            return true;
        }
        return false;
    }

    public void tick() {
        super.tick();
        if (!this.isKeyDown(KeybindHandler.keybind)) {
            this.mc.setScreen(null);
            if (this.slotSelected != -1) {
                int slot = this.slots.get(this.slotSelected);
                PlayerDataHandler.get((Player)this.mc.player).stopLoopcast();
                Record message = !this.controllerStack.isEmpty() ? new MessageChangeControllerSlot(this.controlSlot, slot) : new MessageChangeSocketableSlot(slot);
                MessageRegister.sendToServer(message);
            }
        }
        ImmutableSet set = ImmutableSet.of((Object)this.mc.options.keyUp, (Object)this.mc.options.keyLeft, (Object)this.mc.options.keyDown, (Object)this.mc.options.keyRight, (Object)this.mc.options.keyShift, (Object)this.mc.options.keySprint, (Object[])new KeyMapping[]{this.mc.options.keyJump});
        for (KeyMapping k : set) {
            KeyMapping.set((InputConstants.Key)k.getKey(), (boolean)this.isKeyDown(k));
        }
    }

    public boolean isKeyDown(KeyMapping keybind) {
        InputConstants.Key key = keybind.getKey();
        if (key.getType() == InputConstants.Type.MOUSE) {
            return GLFW.glfwGetMouseButton((long)Minecraft.getInstance().getWindow().getWindow(), (int)key.getValue()) == 1;
        }
        return InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)key.getValue());
    }

    public boolean isPauseScreen() {
        return false;
    }
}

