/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.client.patchouli;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;
import vazkii.psi.client.patchouli.PatchouliUtils;
import vazkii.psi.common.Psi;

public class MultiCraftingProcessor
implements IComponentProcessor {
    private List<CraftingRecipe> recipes;
    private boolean shapeless = true;
    private int longestIngredientSize = 0;
    private boolean hasCustomHeading;

    public void setup(Level level, IVariableProvider variables) {
        if (Minecraft.getInstance().level == null) {
            return;
        }
        List recipeMap = Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor(RecipeType.CRAFTING);
        List<String> names = variables.get("recipes", (HolderLookup.Provider)level.registryAccess()).asStream((HolderLookup.Provider)level.registryAccess()).map(IVariable::asString).toList();
        this.recipes = new ArrayList<CraftingRecipe>();
        for (String name : names) {
            Optional<RecipeHolder> recipe = recipeMap.stream().filter(x -> x.id() == ResourceLocation.parse((String)name)).findFirst();
            if (recipe.isPresent()) {
                this.recipes.add((CraftingRecipe)recipe.get().value());
                if (this.shapeless) {
                    this.shapeless = !(recipe.get().value() instanceof ShapedRecipe);
                }
                for (Ingredient ingredient : ((CraftingRecipe)recipe.get().value()).getIngredients()) {
                    int size = ingredient.getItems().length;
                    if (this.longestIngredientSize >= size) continue;
                    this.longestIngredientSize = size;
                }
                continue;
            }
            Psi.logger.warn("Missing crafting recipe {}", (Object)name);
        }
        this.hasCustomHeading = variables.has("heading");
    }

    @NotNull
    public IVariable process(Level level, String key) {
        if (this.recipes.isEmpty()) {
            return null;
        }
        if (key.equals("heading")) {
            if (!this.hasCustomHeading) {
                return IVariable.from((Object)this.recipes.getFirst().getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY).getHoverName(), (HolderLookup.Provider)level.registryAccess());
            }
            return null;
        }
        if (key.startsWith("input")) {
            int index = Integer.parseInt(key.substring(5)) - 1;
            int shapedX = index % 3;
            int shapedY = index / 3;
            ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
            for (CraftingRecipe recipe2 : this.recipes) {
                if (recipe2 instanceof ShapedRecipe) {
                    ShapedRecipe shaped = (ShapedRecipe)recipe2;
                    if (shaped.getWidth() < shapedX + 1) {
                        ingredients.add(Ingredient.EMPTY);
                        continue;
                    }
                    int realIndex = index - shapedY * (3 - shaped.getWidth());
                    NonNullList list = recipe2.getIngredients();
                    ingredients.add(list.size() > realIndex ? (Ingredient)list.get(realIndex) : Ingredient.EMPTY);
                    continue;
                }
                NonNullList list = recipe2.getIngredients();
                ingredients.add(list.size() > index ? (Ingredient)list.get(index) : Ingredient.EMPTY);
            }
            return PatchouliUtils.interweaveIngredients(ingredients, this.longestIngredientSize, (HolderLookup.Provider)level.registryAccess());
        }
        if (key.equals("output")) {
            return IVariable.wrapList((Iterable)this.recipes.stream().map(recipe -> recipe.getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY)).map(d -> IVariable.from((Object)d, (HolderLookup.Provider)level.registryAccess())).collect(Collectors.toList()), (HolderLookup.Provider)level.registryAccess());
        }
        if (key.equals("shapeless")) {
            return IVariable.wrap((Boolean)this.shapeless, (HolderLookup.Provider)level.registryAccess());
        }
        return null;
    }
}

