/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.mods.tnttime.utils;

import cc.polyfrost.oneconfig.config.core.OneColor;
import cc.polyfrost.oneconfig.utils.hypixel.HypixelUtils;
import club.sk1er.mods.tnttime.config.TNTTimeConfig;
import java.awt.Color;
import java.text.DecimalFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class FuseUtils {
    private static final DecimalFormat DECIMAL_FORMATTER = new DecimalFormat("0.00");
    public static boolean bedwars;
    private int checkTimer;

    public static int adjustFuse(int ticks) {
        return bedwars ? ticks - 28 : ticks;
    }

    public static Color getFuseColor(int ticks) {
        float divisor = bedwars ? 52.0f : 80.0f;
        float progress = Math.min((float)FuseUtils.adjustFuse(ticks) / divisor, 1.0f);
        return FuseUtils.interpolateColor(progress);
    }

    private static Color interpolateColor(float progress) {
        OneColor start = TNTTimeConfig.startColor;
        OneColor end = TNTTimeConfig.endColor;
        int r = (int)((float)end.getRed() + progress * (float)(start.getRed() - end.getRed()));
        int g = (int)((float)end.getGreen() + progress * (float)(start.getGreen() - end.getGreen()));
        int b = (int)((float)end.getBlue() + progress * (float)(start.getBlue() - end.getBlue()));
        return new Color(r, g, b);
    }

    public static String getTimer(int ticks) {
        return DECIMAL_FORMATTER.format((float)ticks / 20.0f);
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START || this.checkTimer++ < 250) {
            return;
        }
        this.checkTimer = 0;
        bedwars = false;
        if (!HypixelUtils.INSTANCE.isHypixel()) {
            return;
        }
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world == null || world.func_96441_U() == null) {
            return;
        }
        bedwars = this.isBedwars(world.func_96441_U());
    }

    private boolean isBedwars(Scoreboard scoreboard) {
        ScoreObjective sidebarObjective = scoreboard.func_96539_a(1);
        if (sidebarObjective == null) {
            return false;
        }
        String name = EnumChatFormatting.func_110646_a((String)sidebarObjective.func_96678_d());
        return name.contains("BED WARS");
    }
}

