/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.command.commands.duel.subcommands;

import com.meteordevelopments.duels.DuelsPlugin;
import com.meteordevelopments.duels.api.event.request.RequestAcceptEvent;
import com.meteordevelopments.duels.command.BaseCommand;
import com.meteordevelopments.duels.hook.hooks.worldguard.WorldGuardHook;
import com.meteordevelopments.duels.party.Party;
import com.meteordevelopments.duels.request.RequestImpl;
import com.meteordevelopments.duels.setting.Settings;
import com.meteordevelopments.duels.util.function.Pair;
import com.meteordevelopments.duels.util.validator.ValidatorUtil;
import java.util.Collection;
import java.util.Collections;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class AcceptCommand
extends BaseCommand {
    private final WorldGuardHook worldGuard;

    public AcceptCommand(DuelsPlugin plugin) {
        super(plugin, "accept", "accept [player]", "Accepts a duel request.", 2, true, new String[0]);
        this.worldGuard = this.hookManager.getHook(WorldGuardHook.class);
    }

    @Override
    protected void execute(CommandSender sender, String label, String[] args) {
        String arena;
        Collection<Player> targetPlayers;
        Collection<Player> players;
        Player player = (Player)sender;
        Party party = this.partyManager.get(player);
        Collection<Player> collection = players = party == null ? Collections.singleton(player) : party.getOnlineMembers();
        if (!ValidatorUtil.validate(this.validatorManager.getDuelAcceptSelfValidators(), player, party, players)) {
            return;
        }
        Player target = Bukkit.getPlayerExact((String)args[1]);
        if (target == null || !player.canSee(target)) {
            this.lang.sendMessage(sender, "ERROR.player.not-found", "name", args[1]);
            return;
        }
        Party targetParty = this.partyManager.get(target);
        Collection<Player> collection2 = targetPlayers = targetParty == null ? Collections.singleton(target) : targetParty.getOnlineMembers();
        if (!ValidatorUtil.validate(this.validatorManager.getDuelAcceptTargetValidators(), new Pair<Player, Player>(player, target), targetParty, targetPlayers)) {
            return;
        }
        RequestImpl request = this.requestManager.remove(target, player);
        RequestAcceptEvent event = new RequestAcceptEvent(player, target, request);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        Settings settings = request.getSettings();
        String kit = settings.getKit() != null ? settings.getKit().getName() : this.lang.getMessage("GENERAL.not-selected");
        String ownInventory = settings.isOwnInventory() ? this.lang.getMessage("GENERAL.enabled") : this.lang.getMessage("GENERAL.disabled");
        String string = arena = settings.getArena() != null ? settings.getArena().getName() : this.lang.getMessage("GENERAL.random");
        if (request.isPartyDuel()) {
            Player targetPartyLeader = request.getTargetParty().getOwner().getPlayer();
            Player senderPartyLeader = request.getSenderParty().getOwner().getPlayer();
            this.lang.sendMessage(Collections.singleton(senderPartyLeader), "COMMAND.duel.party-request.accept.receiver-party", "owner", player.getName(), "name", target.getName(), "kit", kit, "own_inventory", ownInventory, "arena", arena);
            this.lang.sendMessage((CommandSender)targetPartyLeader, "COMMAND.duel.party-request.accept.sender-party", "owner", target.getName(), "name", player.getName(), "kit", kit, "own_inventory", ownInventory, "arena", arena);
        } else {
            double bet = settings.getBet();
            String itemBetting = settings.isItemBetting() ? this.lang.getMessage("GENERAL.enabled") : this.lang.getMessage("GENERAL.disabled");
            this.lang.sendMessage((CommandSender)player, "COMMAND.duel.request.accept.receiver", "name", target.getName(), "kit", kit, "arena", arena, "bet_amount", bet, "item_betting", itemBetting);
            this.lang.sendMessage((CommandSender)target, "COMMAND.duel.request.accept.sender", "name", player.getName(), "kit", kit, "arena", arena, "bet_amount", bet, "item_betting", itemBetting);
        }
        if (settings.isItemBetting()) {
            players.forEach(all -> {
                settings.setBaseLoc((Player)all);
                settings.setDuelzone((Player)all, this.worldGuard != null ? this.worldGuard.findDuelZone((Player)all) : null);
            });
            this.bettingManager.open(settings, target, player);
        } else {
            this.duelManager.startMatch(target, player, settings, null, null);
        }
    }
}

