/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.command.commands.party;

import com.meteordevelopments.duels.DuelsPlugin;
import com.meteordevelopments.duels.command.BaseCommand;
import com.meteordevelopments.duels.command.commands.party.subcommands.AcceptCommand;
import com.meteordevelopments.duels.command.commands.party.subcommands.DisbandCommand;
import com.meteordevelopments.duels.command.commands.party.subcommands.FriendlyfireCommand;
import com.meteordevelopments.duels.command.commands.party.subcommands.KickCommand;
import com.meteordevelopments.duels.command.commands.party.subcommands.LeaveCommand;
import com.meteordevelopments.duels.command.commands.party.subcommands.ListCommand;
import com.meteordevelopments.duels.command.commands.party.subcommands.ToggleCommand;
import com.meteordevelopments.duels.command.commands.party.subcommands.TransferCommand;
import com.meteordevelopments.duels.data.UserData;
import com.meteordevelopments.duels.party.Party;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PartyCommand
extends BaseCommand {
    public PartyCommand(DuelsPlugin plugin) {
        super(plugin, "party", "duels.party", true);
        this.child(new ToggleCommand(plugin), new AcceptCommand(plugin), new ListCommand(plugin), new LeaveCommand(plugin), new KickCommand(plugin), new FriendlyfireCommand(plugin), new TransferCommand(plugin), new DisbandCommand(plugin));
    }

    @Override
    protected boolean executeFirst(CommandSender sender, String label, String[] args) {
        Player player = (Player)sender;
        if (this.containsPlaceholder(args)) {
            this.lang.sendMessage(sender, "ERROR.command.invalid-argument", "arg", String.join((CharSequence)" ", args));
            return true;
        }
        if (args.length == 0) {
            this.lang.sendMessage(sender, "COMMAND.party.usage", "command", label);
            return true;
        }
        if (this.isChild(args[0])) {
            return false;
        }
        Player target = Bukkit.getPlayerExact((String)args[0]);
        if (target == null || !player.canSee(target)) {
            this.lang.sendMessage(sender, "ERROR.player.not-found", "name", args[0]);
            return true;
        }
        if (player.equals((Object)target)) {
            this.lang.sendMessage(sender, "ERROR.party.is-self", new Object[0]);
            return true;
        }
        UserData user = this.userManager.get(target);
        if (user == null) {
            this.lang.sendMessage(sender, "ERROR.data.not-found", "name", target.getName());
            return true;
        }
        if (!user.canPartyRequest()) {
            this.lang.sendMessage(sender, "ERROR.party.requests-disabled", "name", target.getName());
            return true;
        }
        if (this.partyManager.isInParty(target)) {
            this.lang.sendMessage(sender, "ERROR.party.already-in-party.target", "name", target.getName());
            return true;
        }
        if (this.partyManager.hasInvite(player, target)) {
            this.lang.sendMessage(sender, "ERROR.party.already-has-invite", "name", target.getName());
            return true;
        }
        Party party = this.partyManager.getOrCreate(player);
        if (!party.isOwner(player)) {
            this.lang.sendMessage(sender, "ERROR.party.is-not-owner", new Object[0]);
            return true;
        }
        if (!this.partyManager.sendInvite(player, target, party)) {
            this.lang.sendMessage(sender, "ERROR.party.max-size-reached.sender", new Object[0]);
            return true;
        }
        this.lang.sendMessage(party.getOnlineMembers(), "COMMAND.party.invite.send.members", "owner", player.getName(), "name", target.getName());
        this.lang.sendMessage((CommandSender)target, "COMMAND.party.invite.send.receiver", "name", sender.getName());
        return true;
    }

    @Override
    protected void execute(CommandSender sender, String label, String[] args) {
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        return null;
    }

    private boolean containsPlaceholder(String[] args) {
        for (String arg : args) {
            if (!arg.contains("%") && !arg.contains("<") && !arg.contains(">")) continue;
            return true;
        }
        return false;
    }
}

