/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.commands;

import com.meteordevelopments.duels.DuelsPlugin;
import com.meteordevelopments.duels.config.converters.SimpleConfigConverter;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class ConfigMergeCommand
implements CommandExecutor,
TabCompleter {
    private final DuelsPlugin plugin;

    public ConfigMergeCommand(DuelsPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("duels.admin")) {
            sender.sendMessage("\u00a7cYou don't have permission to use this command!");
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage("\u00a7eUsage: /configmerge <config|lang|all>");
            return true;
        }
        String action = args[0].toLowerCase();
        try {
            switch (action) {
                case "config": {
                    SimpleConfigConverter.autoMergeConfig(this.plugin, "config.yml");
                    sender.sendMessage("\u00a7aSuccessfully merged config.yml with defaults!");
                    break;
                }
                case "lang": {
                    SimpleConfigConverter.autoMergeConfig(this.plugin, "lang.yml");
                    sender.sendMessage("\u00a7aSuccessfully merged lang.yml with defaults!");
                    break;
                }
                case "all": {
                    SimpleConfigConverter.autoMergeConfig(this.plugin, "config.yml");
                    SimpleConfigConverter.autoMergeConfig(this.plugin, "lang.yml");
                    sender.sendMessage("\u00a7aSuccessfully merged all configuration files with defaults!");
                    break;
                }
                default: {
                    sender.sendMessage("\u00a7cInvalid option! Use: config, lang, or all");
                    return true;
                }
            }
        }
        catch (Exception e) {
            sender.sendMessage("\u00a7cFailed to merge configuration: " + e.getMessage());
            this.plugin.getLogger().warning("Config merge failed: " + e.getMessage());
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            ArrayList<String> completions = new ArrayList<String>();
            completions.add("config");
            completions.add("lang");
            completions.add("all");
            return completions;
        }
        return new ArrayList<String>();
    }
}

