/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.config.converters;

import com.meteordevelopments.duels.util.config.convert.Converter;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class AutoMergeConverter
implements Converter {
    private final JavaPlugin plugin;
    private final String configName;
    private final String langName;

    public AutoMergeConverter(JavaPlugin plugin, String configName, String langName) {
        this.plugin = plugin;
        this.configName = configName;
        this.langName = langName;
    }

    @Override
    public Map<String, String> renamedKeys() {
        HashMap<String, String> keys = new HashMap<String, String>();
        return keys;
    }

    public void autoMergeConfigs() {
        try {
            this.mergeConfigFile(this.configName);
            this.mergeConfigFile(this.langName);
            this.plugin.getLogger().info("[AutoMerge] Successfully merged configuration files with defaults!");
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("[AutoMerge] Failed to merge configuration files: " + e.getMessage());
        }
    }

    private void mergeConfigFile(String fileName) throws Exception {
        File userFile = new File(this.plugin.getDataFolder(), fileName);
        InputStream defaultStream = this.plugin.getResource(fileName);
        if (defaultStream == null) {
            this.plugin.getLogger().warning("[AutoMerge] Default " + fileName + " not found in resources!");
            return;
        }
        YamlConfiguration userConfig = YamlConfiguration.loadConfiguration((File)userFile);
        YamlConfiguration defaultConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defaultStream));
        FileConfiguration mergedConfig = AutoMergeConverter.mergeConfigurations((FileConfiguration)userConfig, (FileConfiguration)defaultConfig);
        mergedConfig.save(userFile);
        this.plugin.getLogger().info("[AutoMerge] Merged " + fileName + " with default values!");
    }

    public static FileConfiguration mergeConfigurations(FileConfiguration userConfig, FileConfiguration defaultConfig) {
        YamlConfiguration result = new YamlConfiguration();
        for (String key : defaultConfig.getKeys(true)) {
            if (defaultConfig.isConfigurationSection(key)) continue;
            result.set(key, defaultConfig.get(key));
        }
        for (String key : userConfig.getKeys(true)) {
            if (userConfig.isConfigurationSection(key)) continue;
            result.set(key, userConfig.get(key));
        }
        return result;
    }
}

