/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.listeners;

import com.meteordevelopments.duels.DuelsPlugin;
import com.meteordevelopments.duels.arena.ArenaImpl;
import com.meteordevelopments.duels.arena.ArenaManagerImpl;
import com.meteordevelopments.duels.match.DuelMatch;
import com.meteordevelopments.duels.match.team.TeamDuelMatch;
import com.meteordevelopments.duels.spectate.SpectateManagerImpl;
import com.meteordevelopments.duels.util.compat.CompatUtil;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.AreaEffectCloudApplyEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;

public class LingerPotionListener {
    private final ArenaManagerImpl arenaManager;
    private final SpectateManagerImpl spectateManager;

    public LingerPotionListener(DuelsPlugin plugin) {
        this.arenaManager = plugin.getArenaManager();
        this.spectateManager = plugin.getSpectateManager();
        if (CompatUtil.isPre1_9()) {
            return;
        }
        Bukkit.getPluginManager().registerEvents((Listener)new Post1_9Listener(), (Plugin)plugin);
    }

    public class Post1_9Listener
    implements Listener {
        @EventHandler
        public void on(AreaEffectCloudApplyEvent event) {
            DuelMatch duelMatch;
            if (!(event.getEntity().getSource() instanceof Player)) {
                return;
            }
            Player source = (Player)event.getEntity().getSource();
            ArenaImpl arena = LingerPotionListener.this.arenaManager.get(source);
            if (arena == null || !((duelMatch = arena.getMatch()) instanceof TeamDuelMatch)) {
                event.getAffectedEntities().removeIf(entity -> entity instanceof Player && LingerPotionListener.this.spectateManager.isSpectating((Player)entity));
                return;
            }
            TeamDuelMatch teamMatch = (TeamDuelMatch)duelMatch;
            TeamDuelMatch.Team sourceTeam = teamMatch.getPlayerToTeam().get(source);
            event.getAffectedEntities().removeIf(entity -> {
                if (entity instanceof Player) {
                    Player p = (Player)entity;
                    if (LingerPotionListener.this.spectateManager.isSpectating(p)) {
                        return true;
                    }
                    TeamDuelMatch.Team affectedTeam = teamMatch.getPlayerToTeam().get(p);
                    if (affectedTeam != null && affectedTeam.equals(sourceTeam)) {
                        PotionType base;
                        boolean harmful = false;
                        for (PotionEffect eff : event.getEntity().getCustomEffects()) {
                            PotionEffectType t = eff.getType();
                            if (!t.equals((Object)PotionEffectType.POISON) && !t.equals((Object)PotionEffectType.HARM) && !t.equals((Object)PotionEffectType.WITHER) && !t.equals((Object)PotionEffectType.WEAKNESS) && !t.equals((Object)PotionEffectType.SLOW) && !t.equals((Object)PotionEffectType.SLOW_DIGGING) && !t.equals((Object)PotionEffectType.BLINDNESS) && !t.equals((Object)PotionEffectType.CONFUSION) && !t.equals((Object)PotionEffectType.HUNGER) && !t.equals((Object)PotionEffectType.LEVITATION) && !t.equals((Object)PotionEffectType.UNLUCK) && !t.equals((Object)PotionEffectType.BAD_OMEN) && !t.equals((Object)PotionEffectType.DARKNESS)) continue;
                            harmful = true;
                            break;
                        }
                        if (!(harmful || (base = event.getEntity().getBasePotionData().getType()) != PotionType.POISON && base != PotionType.INSTANT_DAMAGE && base != PotionType.SLOWNESS && base != PotionType.WEAKNESS)) {
                            harmful = true;
                        }
                        return harmful;
                    }
                }
                return false;
            });
        }
    }
}

