/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.util.gui;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.meteordevelopments.duels.util.Loadable;
import com.meteordevelopments.duels.util.gui.AbstractGui;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.java.JavaPlugin;

public class GuiListener<P extends JavaPlugin>
implements Loadable,
Listener {
    private final Multimap<UUID, AbstractGui<P>> privateGuis = HashMultimap.create();
    private final List<AbstractGui<P>> publicGuis = new ArrayList<AbstractGui<P>>();

    public GuiListener(P plugin) {
        Bukkit.getPluginManager().registerEvents((Listener)this, plugin);
    }

    @Override
    public void handleLoad() {
    }

    @Override
    public void handleUnload() {
        this.privateGuis.values().forEach(AbstractGui::clear);
        this.privateGuis.clear();
        this.publicGuis.forEach(AbstractGui::clear);
        this.publicGuis.clear();
    }

    public void addGui(AbstractGui<P> gui) {
        this.publicGuis.add(gui);
    }

    public <T extends AbstractGui<P>> T addGui(Player player, T gui, boolean removeSameType) {
        Collection guis;
        if (removeSameType && (guis = (Collection)this.privateGuis.asMap().get(player.getUniqueId())) != null) {
            guis.removeIf(cached -> gui.getClass().isInstance(cached));
        }
        this.privateGuis.put((Object)player.getUniqueId(), gui);
        return gui;
    }

    public <T extends AbstractGui<P>> T addGui(Player player, T gui) {
        return this.addGui(player, gui, false);
    }

    public void removeGui(AbstractGui<P> gui) {
        gui.clear();
        this.publicGuis.remove(gui);
    }

    public void removeGui(Player player, AbstractGui<P> gui) {
        gui.clear();
        Collection guis = (Collection)this.privateGuis.asMap().get(player.getUniqueId());
        if (guis != null) {
            guis.remove(gui);
        }
    }

    private List<AbstractGui<P>> get(Player player) {
        ArrayList guis = Lists.newArrayList(this.publicGuis);
        if (this.privateGuis.containsKey((Object)player.getUniqueId())) {
            guis.addAll(this.privateGuis.get((Object)player.getUniqueId()));
        }
        return guis;
    }

    @EventHandler
    public void on(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        Inventory top = player.getOpenInventory().getTopInventory();
        for (AbstractGui<P> gui : this.get(player)) {
            if (!gui.isPart(top)) continue;
            gui.on(player, top, event);
            break;
        }
    }

    @EventHandler
    public void on(InventoryDragEvent event) {
        Player player = (Player)event.getWhoClicked();
        Inventory inventory = event.getInventory();
        for (AbstractGui<P> gui : this.get(player)) {
            if (!gui.isPart(inventory)) continue;
            gui.on(player, event.getRawSlots(), event);
            break;
        }
    }

    @EventHandler
    public void on(InventoryCloseEvent event) {
        Player player = (Player)event.getPlayer();
        Inventory inventory = event.getInventory();
        for (AbstractGui<P> gui : this.get(player)) {
            if (!gui.isPart(inventory)) continue;
            gui.on(player, event.getInventory(), event);
            break;
        }
    }

    @EventHandler
    public void on(PlayerQuitEvent event) {
        this.privateGuis.removeAll((Object)event.getPlayer().getUniqueId());
    }
}

