/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.setting;

import com.meteordevelopments.duels.DuelsPlugin;
import com.meteordevelopments.duels.arena.ArenaImpl;
import com.meteordevelopments.duels.gui.settings.SettingsGui;
import com.meteordevelopments.duels.kit.KitImpl;
import com.meteordevelopments.duels.party.Party;
import com.meteordevelopments.duels.setting.CachedInfo;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class Settings {
    private final DuelsPlugin plugin;
    private final SettingsGui gui;
    private UUID target;
    private KitImpl kit;
    private ArenaImpl arena;
    private int bet;
    private boolean itemBetting;
    private boolean ownInventory;
    private Map<UUID, CachedInfo> cache = new HashMap<UUID, CachedInfo>();
    private Party senderParty;
    private Party targetParty;

    public Settings(DuelsPlugin plugin, Player player) {
        this.plugin = plugin;
        this.gui = player != null ? plugin.getGuiListener().addGui(player, new SettingsGui(plugin)) : null;
        this.ownInventory = !plugin.getConfiguration().isKitSelectingEnabled();
    }

    public Settings(DuelsPlugin plugin) {
        this(plugin, null);
    }

    public void reset() {
        this.target = null;
        this.senderParty = null;
        this.targetParty = null;
        this.kit = null;
        this.arena = null;
        this.bet = 0;
        this.itemBetting = false;
        this.ownInventory = !this.plugin.getConfiguration().isKitSelectingEnabled();
        this.clearCache();
    }

    public void setTarget(Player target) {
        if (this.target != null && !this.target.equals(target.getUniqueId())) {
            this.reset();
        }
        this.target = target.getUniqueId();
    }

    public void updateGui(Player player) {
        if (this.gui != null) {
            this.gui.update(player);
        }
    }

    public void clearCache() {
        this.cache.clear();
    }

    public void openGui(Player player) {
        this.gui.open(player);
    }

    public void setBaseLoc(Player player) {
        this.cache.computeIfAbsent(player.getUniqueId(), result -> new CachedInfo()).setLocation(player.getLocation().clone());
    }

    public Location getBaseLoc(Player player) {
        CachedInfo info = this.cache.get(player.getUniqueId());
        if (info == null) {
            return null;
        }
        return info.getLocation();
    }

    public void setDuelzone(Player player, String duelzone) {
        this.cache.computeIfAbsent(player.getUniqueId(), result -> new CachedInfo()).setDuelzone(duelzone);
    }

    public String getDuelzone(Player player) {
        CachedInfo info = this.cache.get(player.getUniqueId());
        if (info == null) {
            return null;
        }
        return info.getDuelzone();
    }

    public boolean isPartyDuel() {
        return this.senderParty != null && this.targetParty != null;
    }

    public void setKit(KitImpl kit) {
        this.kit = kit;
        this.ownInventory = false;
    }

    public void setOwnInventory(boolean ownInventory) {
        this.ownInventory = ownInventory;
        if (ownInventory) {
            this.kit = null;
        }
    }

    public Settings lightCopy() {
        Settings copy = new Settings(this.plugin);
        copy.target = this.target;
        copy.senderParty = this.senderParty;
        copy.targetParty = this.targetParty;
        copy.kit = this.kit;
        copy.arena = this.arena;
        copy.bet = this.bet;
        copy.itemBetting = this.itemBetting;
        copy.ownInventory = this.ownInventory;
        copy.cache = new HashMap<UUID, CachedInfo>(this.cache);
        return copy;
    }

    @Generated
    public UUID getTarget() {
        return this.target;
    }

    @Generated
    public KitImpl getKit() {
        return this.kit;
    }

    @Generated
    public ArenaImpl getArena() {
        return this.arena;
    }

    @Generated
    public void setArena(ArenaImpl arena) {
        this.arena = arena;
    }

    @Generated
    public int getBet() {
        return this.bet;
    }

    @Generated
    public void setBet(int bet) {
        this.bet = bet;
    }

    @Generated
    public boolean isItemBetting() {
        return this.itemBetting;
    }

    @Generated
    public void setItemBetting(boolean itemBetting) {
        this.itemBetting = itemBetting;
    }

    @Generated
    public boolean isOwnInventory() {
        return this.ownInventory;
    }

    @Generated
    public Map<UUID, CachedInfo> getCache() {
        return this.cache;
    }

    @Generated
    public Party getSenderParty() {
        return this.senderParty;
    }

    @Generated
    public void setSenderParty(Party senderParty) {
        this.senderParty = senderParty;
    }

    @Generated
    public Party getTargetParty() {
        return this.targetParty;
    }

    @Generated
    public void setTargetParty(Party targetParty) {
        this.targetParty = targetParty;
    }
}

