/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.util.compat;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.meteordevelopments.duels.util.compat.CompatUtil;
import com.meteordevelopments.duels.util.reflect.ReflectionUtil;
import com.mojang.authlib.GameProfile;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.NotNull;

public final class Skulls {
    private static final Method GET_PROFILE;
    private static final Field PROFILE;
    private static final Method SET_PROFILE;
    private static final LoadingCache<Player, GameProfile> cache;

    private Skulls() {
    }

    private static GameProfile getProfile(Player player) throws InvocationTargetException, IllegalAccessException {
        return (GameProfile)GET_PROFILE.invoke((Object)player, new Object[0]);
    }

    public static void setProfile(SkullMeta meta, Player player) {
        if (SET_PROFILE != null) {
            meta.setOwningPlayer((OfflinePlayer)player);
            return;
        }
        try {
            if (CompatUtil.isModernVersion()) {
                meta.setOwningPlayer((OfflinePlayer)player);
            } else {
                GameProfile cached = (GameProfile)cache.get((Object)player);
                PROFILE.set(meta, cached);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static {
        cache = CacheBuilder.newBuilder().maximumSize(1000L).weakKeys().expireAfterAccess(1L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<Player, GameProfile>(){

            public GameProfile load(@NotNull Player player) throws InvocationTargetException, IllegalAccessException {
                return Skulls.getProfile(player);
            }
        });
        Class<?> CB_PLAYER = ReflectionUtil.getCBClass("entity.CraftPlayer");
        GET_PROFILE = ReflectionUtil.getMethod(CB_PLAYER, "getProfile", new Class[0]);
        Class<?> CB_SKULL_META = ReflectionUtil.getCBClass("inventory.CraftMetaSkull");
        PROFILE = ReflectionUtil.getDeclaredField(CB_SKULL_META, "profile");
        SET_PROFILE = ReflectionUtil.getDeclaredMethodUnsafe(CB_SKULL_META, "setProfile", GameProfile.class);
    }
}

