/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.command.commands.kit;

import com.meteordevelopments.duels.DuelsPlugin;
import com.meteordevelopments.duels.api.kit.Kit;
import com.meteordevelopments.duels.command.BaseCommand;
import com.meteordevelopments.duels.gui.kitedit.KitEditGui;
import com.meteordevelopments.duels.kit.KitImpl;
import com.meteordevelopments.duels.kit.edit.KitEditManager;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class KiteditCommand
extends BaseCommand {
    public KiteditCommand(DuelsPlugin plugin) {
        super(plugin, "kitedit", "kitedit [kitname]", "Starts kit editing mode for the specified kit.", 1, true, new String[0]);
    }

    public void executeCommand(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            this.lang.sendMessage(sender, "ERROR.player-only", new Object[0]);
            return;
        }
        Player player = (Player)sender;
        if (args.length < 2) {
            this.openKitEditGui(player);
            return;
        }
        String kitName = args[1];
        if (kitName.equalsIgnoreCase("cancel")) {
            if (!KitEditManager.getInstance().isEditing(player)) {
                this.openKitEditGui(player);
                return;
            }
            KitEditManager.getInstance().abortEditSession(player);
            this.lang.sendMessage((CommandSender)player, "KIT.EDIT.cancelled", new Object[0]);
            return;
        }
        if (KitEditManager.getInstance().isEditing(player)) {
            this.lang.sendMessage((CommandSender)player, "KIT.EDIT.already-editing", new Object[0]);
            return;
        }
        if (this.queueManager.get(player) != null) {
            this.lang.sendMessage((CommandSender)player, "KIT.EDIT.in-queue", new Object[0]);
            return;
        }
        if (this.arenaManager.isInMatch(player)) {
            this.lang.sendMessage((CommandSender)player, "KIT.EDIT.in-match", new Object[0]);
            return;
        }
        KitImpl kit = this.kitManager.get(kitName);
        if (kit == null) {
            this.lang.sendMessage((CommandSender)player, "ERROR.kit.not-found", "name", kitName);
            return;
        }
        if (KitEditManager.getInstance().startEditSession(player, kitName)) {
            this.lang.sendMessage((CommandSender)player, "KIT.EDIT.started", "kit", kitName);
        } else {
            this.lang.sendMessage((CommandSender)player, "KIT.EDIT.start-failed", "kit", kitName);
        }
    }

    private void openKitEditGui(Player player) {
        if (KitEditManager.getInstance().isEditing(player)) {
            this.lang.sendMessage((CommandSender)player, "KIT.EDIT.already-editing", new Object[0]);
            return;
        }
        if (this.queueManager.get(player) != null) {
            this.lang.sendMessage((CommandSender)player, "KIT.EDIT.in-queue", new Object[0]);
            return;
        }
        if (this.arenaManager.isInMatch(player)) {
            this.lang.sendMessage((CommandSender)player, "KIT.EDIT.in-match", new Object[0]);
            return;
        }
        List<Kit> kits = this.kitManager.getKits();
        ArrayList<KitImpl> kitImpls = new ArrayList<KitImpl>();
        for (Kit kit : kits) {
            if (!(kit instanceof KitImpl)) continue;
            kitImpls.add((KitImpl)kit);
        }
        KitEditGui gui = new KitEditGui(this.plugin, kitImpls);
        this.plugin.getGuiListener().addGui(player, gui);
        gui.open(player);
    }

    @Override
    protected void execute(CommandSender sender, String label, String[] args) {
        if (!(sender instanceof Player)) {
            this.lang.sendMessage(sender, "ERROR.player-only", new Object[0]);
            return;
        }
        Player player = (Player)sender;
        if (args.length < 2) {
            this.openKitEditGui(player);
            return;
        }
        String kitName = args[1];
        if (kitName.equalsIgnoreCase("cancel")) {
            if (!KitEditManager.getInstance().isEditing(player)) {
                this.openKitEditGui(player);
                return;
            }
            KitEditManager.getInstance().abortEditSession(player);
            this.lang.sendMessage((CommandSender)player, "KIT.EDIT.cancelled", new Object[0]);
            return;
        }
        if (KitEditManager.getInstance().isEditing(player)) {
            this.lang.sendMessage((CommandSender)player, "KIT.EDIT.already-editing", new Object[0]);
            return;
        }
        if (this.queueManager.get(player) != null) {
            this.lang.sendMessage((CommandSender)player, "KIT.EDIT.in-queue", new Object[0]);
            return;
        }
        if (this.arenaManager.isInMatch(player)) {
            this.lang.sendMessage((CommandSender)player, "KIT.EDIT.in-match", new Object[0]);
            return;
        }
        KitImpl kit = this.kitManager.get(kitName);
        if (kit == null) {
            this.lang.sendMessage((CommandSender)player, "ERROR.kit.not-found", "name", kitName);
            return;
        }
        if (KitEditManager.getInstance().startEditSession(player, kitName)) {
            this.lang.sendMessage((CommandSender)player, "KIT.EDIT.started", "kit", kitName);
        } else {
            this.lang.sendMessage((CommandSender)player, "KIT.EDIT.start-failed", "kit", kitName);
        }
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 2) {
            ArrayList<String> completions = new ArrayList<String>(this.kitManager.getNames(false));
            completions.add("cancel");
            return completions;
        }
        return null;
    }
}

