/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.config.converters;

import com.meteordevelopments.duels.util.config.convert.Converter;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class SimpleConfigConverter
implements Converter {
    @Override
    public Map<String, String> renamedKeys() {
        HashMap<String, String> keys = new HashMap<String, String>();
        return keys;
    }

    public static void autoMergeConfig(JavaPlugin plugin, String fileName) {
        try {
            File userFile = new File(plugin.getDataFolder(), fileName);
            InputStream defaultStream = plugin.getResource(fileName);
            if (defaultStream == null) {
                plugin.getLogger().warning("[AutoMerge] Default " + fileName + " not found in resources!");
                return;
            }
            YamlConfiguration userConfig = YamlConfiguration.loadConfiguration((File)userFile);
            YamlConfiguration defaultConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defaultStream));
            FileConfiguration mergedConfig = SimpleConfigConverter.mergeConfigurations((FileConfiguration)userConfig, (FileConfiguration)defaultConfig);
            mergedConfig.save(userFile);
            plugin.getLogger().info("[AutoMerge] Successfully merged " + fileName + " with default values!");
        }
        catch (Exception e) {
            plugin.getLogger().warning("[AutoMerge] Failed to merge " + fileName + ": " + e.getMessage());
        }
    }

    public static FileConfiguration mergeConfigurations(FileConfiguration userConfig, FileConfiguration defaultConfig) {
        YamlConfiguration result = new YamlConfiguration();
        for (String key : defaultConfig.getKeys(true)) {
            if (defaultConfig.isConfigurationSection(key)) continue;
            result.set(key, defaultConfig.get(key));
        }
        for (String key : userConfig.getKeys(true)) {
            if (userConfig.isConfigurationSection(key)) continue;
            result.set(key, userConfig.get(key));
        }
        return result;
    }
}

