/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.extension;

import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import lombok.Generated;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ExtensionInfo {
    private final String name;
    private final String version;
    private final String main;
    private final String apiVersion;
    private final String description;
    private final String website;
    private final List<String> depends;
    private final List<String> authors;

    ExtensionInfo(File file) throws Exception {
        try (JarFile jar = new JarFile(file);){
            JarEntry entry = jar.getJarEntry("extension.yml");
            if (entry == null) {
                throw new RuntimeException("No extension.yml found");
            }
            try (InputStreamReader reader = new InputStreamReader(jar.getInputStream(entry));){
                YamlConfiguration config = YamlConfiguration.loadConfiguration((Reader)reader);
                this.name = this.getOrThrow((FileConfiguration)config, "name");
                this.version = this.getOrThrow((FileConfiguration)config, "version");
                this.main = this.getOrThrow((FileConfiguration)config, "main");
                this.apiVersion = config.getString("api-version");
                this.description = config.getString("description", "not specified");
                this.website = config.getString("description", "not specified");
                this.depends = config.getStringList("depends");
                this.authors = config.getStringList("authors");
            }
        }
    }

    private String getOrThrow(FileConfiguration config, String path) {
        String result = config.getString(path);
        if (result == null) {
            throw new RuntimeException("No " + path + " specified in extension.yml");
        }
        return result;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public String getMain() {
        return this.main;
    }

    @Generated
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getWebsite() {
        return this.website;
    }

    @Generated
    public List<String> getDepends() {
        return this.depends;
    }

    @Generated
    public List<String> getAuthors() {
        return this.authors;
    }
}

