/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.gui.kitedit;

import com.meteordevelopments.duels.DuelsPlugin;
import com.meteordevelopments.duels.gui.kitedit.buttons.KitEditButton;
import com.meteordevelopments.duels.kit.KitImpl;
import com.meteordevelopments.duels.util.compat.Items;
import com.meteordevelopments.duels.util.gui.MultiPageGui;
import com.meteordevelopments.duels.util.inventory.ItemBuilder;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;

public class KitEditGui
extends MultiPageGui<DuelsPlugin> {
    public KitEditGui(DuelsPlugin plugin, List<KitImpl> kits) {
        super(plugin, plugin.getLang().getMessage("GUI.kit-edit-selector.title"), plugin.getConfiguration().getKitSelectorRows(), KitEditGui.convertToButtons(plugin, kits));
        this.setSpaceFiller(Items.from(plugin.getConfiguration().getKitSelectorFillerType(), plugin.getConfiguration().getKitSelectorFillerData()));
        this.setPrevButton(ItemBuilder.of(Material.PAPER).name(plugin.getLang().getMessage("GUI.kit-edit-selector.buttons.previous-page.name"), plugin.getLang()).build());
        this.setNextButton(ItemBuilder.of(Material.PAPER).name(plugin.getLang().getMessage("GUI.kit-edit-selector.buttons.next-page.name"), plugin.getLang()).build());
        this.setEmptyIndicator(ItemBuilder.of(Material.PAPER).name(plugin.getLang().getMessage("GUI.kit-edit-selector.buttons.empty.name"), plugin.getLang()).build());
        this.calculatePages();
    }

    private static List<KitEditButton> convertToButtons(DuelsPlugin plugin, List<KitImpl> kits) {
        ArrayList<KitEditButton> buttons = new ArrayList<KitEditButton>();
        for (KitImpl kit : kits) {
            buttons.add(new KitEditButton(plugin, kit));
        }
        return buttons;
    }
}

