/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.hook.hooks;

import com.meteordevelopments.duels.DuelsPlugin;
import com.meteordevelopments.duels.arena.ArenaManagerImpl;
import com.meteordevelopments.duels.config.Config;
import com.meteordevelopments.duels.util.hook.PluginHook;
import nl.marido.deluxecombat.api.DeluxeCombatAPI;
import nl.marido.deluxecombat.events.CombatStateChangeEvent;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class DeluxeCombatHook
extends PluginHook<DuelsPlugin> {
    public static final String NAME = "DeluxeCombat";
    private final Config config;
    private final ArenaManagerImpl arenaManager;
    DeluxeCombatAPI api = new DeluxeCombatAPI();

    public DeluxeCombatHook(DuelsPlugin plugin) {
        super(plugin, NAME);
        this.config = plugin.getConfiguration();
        this.arenaManager = plugin.getArenaManager();
        try {
            Class.forName("nl.marido.deluxecombat.events.CombatStateChangeEvent");
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException("This version of " + this.getName() + " is not supported. Please try upgrading to the latest version.");
        }
        Bukkit.getPluginManager().registerEvents((Listener)new DeluxeCombatListener(), (Plugin)plugin);
    }

    public boolean isTagged(Player player) {
        return this.config.isDcPreventDuel() && this.api.isInCombat(player);
    }

    public class DeluxeCombatListener
    implements Listener {
        @EventHandler(ignoreCancelled=true)
        public void on(CombatStateChangeEvent event) {
            if (!DeluxeCombatHook.this.config.isDcPreventTag()) {
                return;
            }
            Player player = event.getPlayer();
            if (!DeluxeCombatHook.this.arenaManager.isInMatch(player)) {
                return;
            }
            DeluxeCombatHook.this.api.untag(player);
        }
    }
}

