/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.kit.edit;

import com.meteordevelopments.duels-optimised.shaded.paperlib.PaperLib;
import java.util.Arrays;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class EditSession {
    private final UUID playerId;
    private final String playerName;
    private final String kitName;
    private final ItemStack[] originalInventory;
    private final ItemStack[] originalArmor;
    private final ItemStack originalOffhand;
    private final long sessionStartTime;
    private final Location playerLoc;

    public EditSession(Player player, String kitName) {
        this.playerId = player.getUniqueId();
        this.playerName = player.getName();
        this.kitName = kitName;
        this.sessionStartTime = System.currentTimeMillis();
        PlayerInventory inv = player.getInventory();
        this.originalInventory = (ItemStack[])Arrays.stream(inv.getContents()).map(item -> item != null ? item.clone() : null).toArray(ItemStack[]::new);
        this.originalArmor = (ItemStack[])Arrays.stream(inv.getArmorContents()).map(item -> item != null ? item.clone() : null).toArray(ItemStack[]::new);
        this.originalOffhand = inv.getItemInOffHand() != null ? inv.getItemInOffHand().clone() : null;
        this.playerLoc = player.getLocation();
    }

    public ItemStack[] getOriginalInventory() {
        return (ItemStack[])Arrays.stream(this.originalInventory).map(item -> item != null ? item.clone() : null).toArray(ItemStack[]::new);
    }

    public ItemStack[] getOriginalArmor() {
        return (ItemStack[])Arrays.stream(this.originalArmor).map(item -> item != null ? item.clone() : null).toArray(ItemStack[]::new);
    }

    public ItemStack getOriginalOffhand() {
        return this.originalOffhand != null ? this.originalOffhand.clone() : null;
    }

    public Location getPlayerOriginalLoc() {
        return this.playerLoc;
    }

    public void restoreInventory(Player player) {
        PlayerInventory inv = player.getInventory();
        inv.clear();
        ItemStack[] restoredInventory = this.getOriginalInventory();
        for (int i = 0; i < restoredInventory.length; ++i) {
            inv.setItem(i, restoredInventory[i]);
        }
        inv.setArmorContents(this.getOriginalArmor());
        inv.setItemInOffHand(this.getOriginalOffhand());
        player.updateInventory();
    }

    public void returnToOldLocation(Player player) {
        PaperLib.teleportAsync((Entity)player, this.getPlayerOriginalLoc());
    }

    @Generated
    public UUID getPlayerId() {
        return this.playerId;
    }

    @Generated
    public String getPlayerName() {
        return this.playerName;
    }

    @Generated
    public String getKitName() {
        return this.kitName;
    }

    @Generated
    public long getSessionStartTime() {
        return this.sessionStartTime;
    }
}

