/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.listeners;

import com.meteordevelopments.duels.DuelsPlugin;
import com.meteordevelopments.duels.arena.ArenaManagerImpl;
import com.meteordevelopments.duels.config.Lang;
import com.meteordevelopments.duels.spectate.SpectateManagerImpl;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;

public class TeleportListener
implements Listener {
    private final Lang lang;
    private final ArenaManagerImpl arenaManager;
    private final SpectateManagerImpl spectateManager;

    public TeleportListener(DuelsPlugin plugin) {
        this.lang = plugin.getLang();
        this.arenaManager = plugin.getArenaManager();
        this.spectateManager = plugin.getSpectateManager();
        if (plugin.getConfiguration().isPreventTpToMatchPlayers()) {
            Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        }
    }

    private boolean isSimilar(Location first, Location second) {
        return Math.abs(first.getX() - second.getX()) + Math.abs(first.getY() - second.getY()) + Math.abs(first.getZ() - second.getZ()) < 5.0;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void on(PlayerTeleportEvent event) {
        Player player = event.getPlayer();
        if (player.isOp() || player.isDead() || player.hasPermission("duels.admin") || player.hasPermission("duels.teleport.bypass") || player.hasMetadata("Duels-Teleport") || this.arenaManager.isInMatch(player) || this.spectateManager.isSpectating(player)) {
            return;
        }
        Location to = event.getTo();
        Set<Player> players = this.arenaManager.getPlayers();
        players.addAll(this.spectateManager.getAllSpectators());
        for (Player target : players) {
            if (target == null || player.equals((Object)target) || !target.isOnline() || !this.isSimilar(target.getLocation(), to)) continue;
            event.setCancelled(true);
            this.lang.sendMessage((CommandSender)player, "ERROR.duel.prevent-teleportation", new Object[0]);
            return;
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onTP(PlayerTeleportEvent event) {
        Player player = event.getPlayer();
        if (!this.arenaManager.isInMatch(player)) {
            return;
        }
        player.closeInventory();
    }
}

