/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.validator.validators.request.self;

import com.meteordevelopments.duels.DuelsPlugin;
import com.meteordevelopments.duels.hook.hooks.CombatLogXHook;
import com.meteordevelopments.duels.hook.hooks.CombatTagPlusHook;
import com.meteordevelopments.duels.hook.hooks.DeluxeCombatHook;
import com.meteordevelopments.duels.hook.hooks.PvPManagerHook;
import com.meteordevelopments.duels.party.Party;
import com.meteordevelopments.duels.validator.BaseTriValidator;
import java.util.Collection;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SelfCombatTagValidator
extends BaseTriValidator<Player, Party, Collection<Player>> {
    private static final String MESSAGE_KEY = "ERROR.duel.is-tagged";
    private static final String PARTY_MESSAGE_KEY = "ERROR.party-duel.is-tagged";
    private final CombatTagPlusHook combatTagPlus;
    private final PvPManagerHook pvpManager;
    private final CombatLogXHook combatLogX;
    private final DeluxeCombatHook deluxeCombat;

    public SelfCombatTagValidator(DuelsPlugin plugin) {
        super(plugin);
        this.combatTagPlus = plugin.getHookManager().getHook(CombatTagPlusHook.class);
        this.pvpManager = plugin.getHookManager().getHook(PvPManagerHook.class);
        this.combatLogX = plugin.getHookManager().getHook(CombatLogXHook.class);
        this.deluxeCombat = plugin.getHookManager().getHook(DeluxeCombatHook.class);
    }

    @Override
    public boolean shouldValidate() {
        return this.combatTagPlus != null && this.config.isCtpPreventDuel() || this.pvpManager != null && this.config.isPmPreventDuel() || this.combatLogX != null && this.config.isClxPreventDuel() || this.deluxeCombat != null && this.config.isDcPreventDuel();
    }

    private boolean isTagged(Player player) {
        return this.combatTagPlus != null && this.combatTagPlus.isTagged(player) || this.pvpManager != null && this.pvpManager.isTagged(player) || this.combatLogX != null && this.combatLogX.isTagged(player) || this.deluxeCombat != null && this.deluxeCombat.isTagged(player);
    }

    @Override
    public boolean validate(Player sender, Party party, Collection<Player> players) {
        if (players.stream().anyMatch(this::isTagged)) {
            this.lang.sendMessage((CommandSender)sender, party != null ? PARTY_MESSAGE_KEY : MESSAGE_KEY, new Object[0]);
            return false;
        }
        return true;
    }
}

