/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels-optimised.shaded.morepaperlib.scheduling;

import com.meteordevelopments.duels-optimised.shaded.morepaperlib.scheduling.ScheduledTask;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.scheduler.BukkitTask;

class PaperTask
implements ScheduledTask {
    private final BukkitScheduler scheduler;
    private final BukkitTask task;

    PaperTask(BukkitScheduler scheduler, BukkitTask task) {
        this.scheduler = scheduler;
        this.task = task;
    }

    @Override
    public Plugin owningPlugin() {
        return this.task.getOwner();
    }

    @Override
    public void cancel() {
        this.task.cancel();
    }

    @Override
    public boolean isCancelled() {
        return this.task.isCancelled();
    }

    @Override
    public ScheduledTask.ExecutionState getExecutionState() {
        int taskId = this.task.getTaskId();
        if (this.task.isCancelled()) {
            return this.scheduler.isCurrentlyRunning(taskId) ? ScheduledTask.ExecutionState.CANCELLED_RUNNING : ScheduledTask.ExecutionState.CANCELLED;
        }
        if (this.scheduler.isCurrentlyRunning(taskId)) {
            return ScheduledTask.ExecutionState.RUNNING;
        }
        if (this.scheduler.isQueued(taskId)) {
            return ScheduledTask.ExecutionState.IDLE;
        }
        return ScheduledTask.ExecutionState.FINISHED;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaperTask paperTask = (PaperTask)o;
        return this.task.equals(paperTask.task);
    }

    public int hashCode() {
        return this.task.hashCode();
    }

    public String toString() {
        return "PaperTask{task=" + this.task + '}';
    }
}

