/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.command.commands.duel;

import com.meteordevelopments.duels.DuelsPlugin;
import com.meteordevelopments.duels.command.BaseCommand;
import com.meteordevelopments.duels.command.commands.duel.subcommands.AcceptCommand;
import com.meteordevelopments.duels.command.commands.duel.subcommands.DenyCommand;
import com.meteordevelopments.duels.command.commands.duel.subcommands.InventoryCommand;
import com.meteordevelopments.duels.command.commands.duel.subcommands.StatsCommand;
import com.meteordevelopments.duels.command.commands.duel.subcommands.ToggleCommand;
import com.meteordevelopments.duels.command.commands.duel.subcommands.TopCommand;
import com.meteordevelopments.duels.command.commands.duel.subcommands.VersionCommand;
import com.meteordevelopments.duels.hook.hooks.VaultHook;
import com.meteordevelopments.duels.hook.hooks.worldguard.WorldGuardHook;
import com.meteordevelopments.duels.kit.KitImpl;
import com.meteordevelopments.duels.party.Party;
import com.meteordevelopments.duels.setting.Settings;
import com.meteordevelopments.duels.util.NumberUtil;
import com.meteordevelopments.duels.util.StringUtil;
import com.meteordevelopments.duels.util.function.Pair;
import com.meteordevelopments.duels.util.validator.ValidatorUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class DuelCommand
extends BaseCommand {
    private final WorldGuardHook worldGuard;
    private final VaultHook vault;

    public DuelCommand(DuelsPlugin plugin) {
        super(plugin, "duel", "duels.duel", true);
        this.child(new AcceptCommand(plugin), new DenyCommand(plugin), new StatsCommand(plugin), new ToggleCommand(plugin), new TopCommand(plugin), new InventoryCommand(plugin), new VersionCommand(plugin));
        this.worldGuard = this.hookManager.getHook(WorldGuardHook.class);
        this.vault = this.hookManager.getHook(VaultHook.class);
    }

    @Override
    protected boolean executeFirst(CommandSender sender, String label, String[] args) {
        Collection<Player> targetPlayers;
        Collection<Player> players;
        Player player = (Player)sender;
        if (this.containsPlaceholder(args)) {
            this.lang.sendMessage(sender, "ERROR.command.invalid-argument", "arg", String.join((CharSequence)" ", args));
            return true;
        }
        if (this.userManager.get(player) == null) {
            this.lang.sendMessage(sender, "ERROR.data.load-failure", new Object[0]);
            return true;
        }
        if (args.length == 0) {
            this.lang.sendMessage(sender, "COMMAND.duel.usage", "command", label);
            return true;
        }
        if (this.isChild(args[0])) {
            return false;
        }
        Party party = this.partyManager.get(player);
        Collection<Player> collection = players = party == null ? Collections.singleton(player) : party.getOnlineMembers();
        if (!ValidatorUtil.validate(this.validatorManager.getDuelSelfValidators(), player, party, players)) {
            return true;
        }
        Player target = Bukkit.getPlayerExact((String)args[0]);
        if (target == null || !player.canSee(target)) {
            this.lang.sendMessage(sender, "ERROR.player.not-found", "name", args[0]);
            return true;
        }
        Party targetParty = this.partyManager.get(target);
        Collection<Player> collection2 = targetPlayers = targetParty == null ? Collections.singleton(target) : targetParty.getOnlineMembers();
        if (!ValidatorUtil.validate(this.validatorManager.getDuelTargetValidators(), new Pair<Player, Player>(player, target), targetParty, targetPlayers)) {
            return true;
        }
        Settings settings = this.settingManager.getSafely(player);
        settings.setBet(0);
        settings.setTarget(target);
        settings.setSenderParty(party);
        settings.setTargetParty(targetParty);
        settings.clearCache();
        players.forEach(all -> {
            settings.setBaseLoc((Player)all);
            settings.setDuelzone((Player)all, this.worldGuard != null ? this.worldGuard.findDuelZone((Player)all) : null);
        });
        boolean sendRequest = false;
        if (args.length > 1) {
            if (party != null) {
                this.lang.sendMessage(sender, "ERROR.party-duel.option-unavailable", new Object[0]);
                return true;
            }
            int amount = NumberUtil.parseInt(args[1]).orElse(0);
            if (amount > 0 && this.config.isMoneyBettingEnabled()) {
                if (this.config.isMoneyBettingUsePermission() && !player.hasPermission("duels.use.money-betting") && !player.hasPermission("duels.use.*")) {
                    this.lang.sendMessage((CommandSender)player, "ERROR.no-permission", "permission", "duels.use.money-betting");
                    return true;
                }
                if (this.vault == null || this.vault.getEconomy() == null) {
                    this.lang.sendMessage(sender, "ERROR.setting.disabled-option", "option", this.lang.getMessage("GENERAL.betting"));
                    return true;
                }
                if (!this.vault.getEconomy().has((OfflinePlayer)player, (double)amount)) {
                    this.lang.sendMessage(sender, "ERROR.command.not-enough-money", new Object[0]);
                    return true;
                }
                settings.setBet(amount);
            }
            if (args.length > 2) {
                if (args[2].equalsIgnoreCase("true")) {
                    if (!this.config.isItemBettingEnabled()) {
                        this.lang.sendMessage((CommandSender)player, "ERROR.setting.disabled-option", "option", this.lang.getMessage("GENERAL.item-betting"));
                        return true;
                    }
                    if (this.config.isItemBettingUsePermission() && !player.hasPermission("duels.use.item-betting") && !player.hasPermission("duels.use.*")) {
                        this.lang.sendMessage((CommandSender)player, "ERROR.no-permission", "permission", "duels.use.item-betting");
                        return true;
                    }
                    settings.setItemBetting(true);
                }
                if (args.length > 3) {
                    if (args[3].equals("-")) {
                        if (!this.config.isOwnInventoryEnabled()) {
                            this.lang.sendMessage((CommandSender)player, "ERROR.setting.disabled-option", "option", this.lang.getMessage("GENERAL.own-inventory"));
                            return true;
                        }
                        if (this.config.isOwnInventoryUsePermission() && !player.hasPermission("duels.use.own-inventory") && !player.hasPermission("duels.use.*")) {
                            this.lang.sendMessage((CommandSender)player, "ERROR.no-permission", "permission", "duels.use.own-inventory");
                            return true;
                        }
                        settings.setOwnInventory(true);
                    } else {
                        if (!this.config.isKitSelectingEnabled()) {
                            this.lang.sendMessage((CommandSender)player, "ERROR.setting.disabled-option", "option", this.lang.getMessage("GENERAL.kit-selector"));
                            return true;
                        }
                        String name = StringUtil.join(args, " ", 3, args.length);
                        KitImpl kit = this.kitManager.get(name);
                        if (kit == null) {
                            this.lang.sendMessage(sender, "ERROR.kit.not-found", "name", name);
                            return true;
                        }
                        String permission = String.format("duels.kits.%s", name.replace(" ", "-").toLowerCase());
                        if (kit.isUsePermission() && !player.hasPermission("duels.kits.*") && !player.hasPermission(permission)) {
                            this.lang.sendMessage((CommandSender)player, "ERROR.no-permission", "permission", permission);
                            return true;
                        }
                        settings.setKit(kit);
                    }
                    sendRequest = true;
                }
            }
        }
        if (sendRequest) {
            this.requestManager.send(player, target, settings);
        } else if (this.config.isOwnInventoryEnabled()) {
            settings.openGui(player);
        } else {
            this.kitManager.getGui().open(player);
        }
        return true;
    }

    @Override
    protected void execute(CommandSender sender, String label, String[] args) {
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        return null;
    }

    private boolean containsPlaceholder(String[] args) {
        for (String arg : args) {
            if (!arg.contains("%") && !arg.contains("<") && !arg.contains(">")) continue;
            return true;
        }
        return false;
    }
}

