/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.command.commands.duel.subcommands;

import com.meteordevelopments.duels.DuelsPlugin;
import com.meteordevelopments.duels.api.event.request.RequestDenyEvent;
import com.meteordevelopments.duels.command.BaseCommand;
import com.meteordevelopments.duels.request.RequestImpl;
import com.meteordevelopments.duels.util.function.Pair;
import com.meteordevelopments.duels.util.validator.ValidatorUtil;
import java.util.Collections;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class DenyCommand
extends BaseCommand {
    public DenyCommand(DuelsPlugin plugin) {
        super(plugin, "deny", "deny [player]", "Declines a duel request.", 2, true, new String[0]);
    }

    @Override
    protected void execute(CommandSender sender, String label, String[] args) {
        Player player = (Player)sender;
        Player target = Bukkit.getPlayerExact((String)args[1]);
        if (target == null || !player.canSee(target)) {
            this.lang.sendMessage(sender, "ERROR.player.not-found", "name", args[1]);
            return;
        }
        if (!ValidatorUtil.validate(this.validatorManager.getDuelDenyTargetValidators(), new Pair<Player, Player>(player, target), this.partyManager.get(target), Collections.emptyList())) {
            return;
        }
        RequestImpl request = this.requestManager.remove(target, player);
        RequestDenyEvent event = new RequestDenyEvent(player, target, request);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (request.isPartyDuel()) {
            Player targetPartyLeader = request.getTargetParty().getOwner().getPlayer();
            Player senderPartyLeader = request.getSenderParty().getOwner().getPlayer();
            this.lang.sendMessage(Collections.singleton(senderPartyLeader), "COMMAND.duel.party-request.deny.receiver-party", "owner", player.getName(), "name", target.getName());
            this.lang.sendMessage((CommandSender)targetPartyLeader, "COMMAND.duel.party-request.deny.sender-party", "owner", target.getName(), "name", player.getName());
        } else {
            this.lang.sendMessage((CommandSender)player, "COMMAND.duel.request.deny.receiver", "name", target.getName());
            this.lang.sendMessage((CommandSender)target, "COMMAND.duel.request.deny.sender", "name", player.getName());
        }
    }
}

