/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.command.commands.party.subcommands;

import com.meteordevelopments.duels.DuelsPlugin;
import com.meteordevelopments.duels.command.BaseCommand;
import com.meteordevelopments.duels.party.Party;
import com.meteordevelopments.duels.party.PartyInvite;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AcceptCommand
extends BaseCommand {
    public AcceptCommand(DuelsPlugin plugin) {
        super(plugin, "accept", "accept [player]", "Accepts a party invitation.", "duels.party", 2, true, "a");
    }

    @Override
    protected void execute(CommandSender sender, String label, String[] args) {
        Player player = (Player)sender;
        if (this.partyManager.isInParty(player)) {
            this.lang.sendMessage(sender, "ERROR.party.already-in-party.sender", new Object[0]);
            return;
        }
        Player target = Bukkit.getPlayerExact((String)args[1]);
        if (target == null || !player.canSee(target)) {
            this.lang.sendMessage(sender, "ERROR.player.not-found", "name", args[1]);
            return;
        }
        PartyInvite invite = this.partyManager.removeInvite(target, player);
        if (invite == null) {
            this.lang.sendMessage(sender, "ERROR.party.no-invite", "name", target.getName());
            return;
        }
        Party party = invite.getParty();
        if (party.isRemoved()) {
            this.lang.sendMessage(sender, "ERROR.party.not-found", new Object[0]);
            return;
        }
        if (party.size() >= this.config.getPartyMaxSize()) {
            this.lang.sendMessage(sender, "ERROR.party.max-size-reached.target", "name", target.getName());
            return;
        }
        this.lang.sendMessage((CommandSender)player, "COMMAND.party.invite.accept.receiver", "name", target.getName());
        this.lang.sendMessage(party.getOnlineMembers(), "COMMAND.party.invite.accept.members", "name", player.getName());
        this.partyManager.join(player, party);
    }
}

