/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.config;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.meteordevelopments.duels.DuelsPlugin;
import com.meteordevelopments.duels.config.converters.ConfigConverter9_10;
import com.meteordevelopments.duels.util.EnumUtil;
import com.meteordevelopments.duels.util.config.AbstractConfiguration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.bukkit.Sound;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class Config
extends AbstractConfiguration<DuelsPlugin> {
    private final Map<String, MessageSound> sounds = new HashMap<String, MessageSound>();
    private int version;
    private boolean checkForUpdates;
    private boolean ctpPreventDuel;
    private boolean ctpPreventTag;
    private boolean pmPreventDuel;
    private boolean pmPreventTag;
    private boolean clxPreventDuel;
    private boolean clxPreventTag;
    private boolean dcPreventDuel;
    private boolean dcPreventTag;
    private boolean autoUnvanish;
    private boolean setBackLocation;
    private boolean disableSkills;
    private boolean fuNoPowerLoss;
    private boolean fNoPowerLoss;
    private boolean duelzoneEnabled;
    private List<String> duelzones;
    private boolean myPetDespawn;
    private boolean preventBountyLoss;
    private boolean preventBountyLossByNotBounties;
    private boolean preventKDRChange;
    private String lhWinsCmd;
    private String lhWinsTitle;
    private String lhLossesCmd;
    private String lhLossesTitle;
    private boolean requiresClearedInventory;
    private boolean preventCreativeMode;
    private boolean ownInventoryEnabled;
    private boolean ownInventoryDropInventoryItems;
    private boolean ownInventoryUsePermission;
    private boolean kitSelectingEnabled;
    private boolean kitSelectingUsePermission;
    private boolean arenaSelectingEnabled;
    private boolean arenaSelectingUsePermission;
    private boolean itemBettingEnabled;
    private boolean itemBettingUsePermission;
    private boolean moneyBettingEnabled;
    private boolean moneyBettingUsePermission;
    private int expiration;
    private int maxDuration;
    private boolean startCommandsEnabled;
    private boolean startCommandsQueueOnly;
    private List<String> startCommands;
    private boolean endCommandsEnabled;
    private boolean endCommandsQueueOnly;
    private List<String> endCommands;
    private boolean projectileHitMessageEnabled;
    private List<String> projectileHitMessageTypes;
    private boolean preventInventoryOpen;
    private boolean protectKitItems;
    private boolean removeEmptyBottle;
    private boolean preventTpToMatchPlayers;
    private boolean forceAllowCombat;
    private boolean cancelIfMoved;
    private List<String> blacklistedWorlds;
    private boolean teleportToLastLocation;
    private int teleportDelay;
    private boolean spawnFirework;
    private boolean arenaOnlyEndMessage;
    private boolean displayInventories;
    private boolean preventItemDrop;
    private boolean preventItemPickup;
    private boolean limitTeleportEnabled;
    private double distanceAllowed;
    private boolean blockAllCommands;
    private List<String> whitelistedCommands;
    private List<String> blacklistedCommands;
    private List<String> queueBlacklistedCommands;
    private boolean ratingEnabled;
    private int kFactor;
    private int maxDifference;
    private int defaultRating;
    private boolean ratingQueueOnly;
    private boolean specRequiresClearedInventory;
    private boolean specUseSpectatorGamemode;
    private boolean specAddInvisibilityEffect;
    private List<String> specWhitelistedCommands;
    private boolean cdEnabled;
    private boolean preventMovement;
    private boolean preventLaunchProjectile;
    private boolean preventPvp;
    private boolean preventInteract;
    private boolean displayKitRatings;
    private boolean displayNoKitRating;
    private boolean displayPastMatches;
    private int matchesToDisplay;
    private long topUpdateInterval;
    private String topWinsType;
    private String topWinsIdentifier;
    private String topLossesType;
    private String topLossesIdentifier;
    private String topKitType;
    private String topKitIdentifier;
    private String topNoKitType;
    private String topNoKitIdentifier;
    private int kitSelectorRows;
    private String kitSelectorFillerType;
    private short kitSelectorFillerData;
    private int arenaSelectorRows;
    private String arenaSelectorFillerType;
    private short arenaSelectorFillerData;
    private String settingsFillerType;
    private short settingsFillerData;
    private int queuesRows;
    private String queuesFillerType;
    private short queuesFillerData;
    private boolean inheritKitItemType;
    private double soupHeartsToRegen;
    private boolean soupRemoveEmptyBowl;
    private boolean soupCancelIfAlreadyFull;
    private String fireworkColour;
    private String fireworkType;
    private boolean clearItemsAfterMatch;
    private boolean stayUpToDate;
    private boolean disableEnderpearlInEndgame;
    private boolean disableMovementInEndgame;
    private boolean sendDeathMessages;
    private int partyInviteExpiration;
    private int partyAutoDisbandAfter;
    private int partyMaxSize;
    private boolean partySameSizeOnly;
    private List<String> cdDuelMessages;
    private List<String> cdDuelTitles;
    private List<String> cdPartyDuelMessages;
    private List<String> cdPartyDuelTitles;
    private boolean AXpreventGraves;
    private String userNotFound;
    private String notInMatch;
    private String durationFormat;
    private String noKit;
    private String noOpponent;
    private final Multimap<String, MessageSound> messageToSounds = HashMultimap.create();

    public Config(DuelsPlugin plugin) {
        super(plugin, "config");
    }

    @Override
    protected void loadValues(FileConfiguration configuration) throws Exception {
        int prevVersion = configuration.getInt("config-version", 0);
        if (prevVersion < 10) {
            configuration = this.convert(new ConfigConverter9_10());
        } else if (prevVersion < this.getLatestVersion()) {
            configuration = this.convert(null);
        }
        this.version = configuration.getInt("config-version");
        this.checkForUpdates = configuration.getBoolean("check-for-updates", true);
        this.userNotFound = configuration.getString("placeholders.user-not-found", "User not found");
        this.notInMatch = configuration.getString("placeholders.not-in-match", "none");
        this.durationFormat = configuration.getString("placeholders.duration-format", "mm:ss");
        this.noKit = configuration.getString("placeholders.no-kit", "none");
        this.noOpponent = configuration.getString("placeholders.no-opponent", "no opponent");
        this.ctpPreventDuel = configuration.getBoolean("supported-plugins.CombatTagPlus.prevent-duel-if-tagged", true);
        this.ctpPreventTag = configuration.getBoolean("supported-plugins.CombatTagPlus.prevent-tag-in-duel", true);
        this.pmPreventDuel = configuration.getBoolean("supported-plugins.PvPManager.prevent-duel-if-tagged", true);
        this.pmPreventTag = configuration.getBoolean("supported-plugins.PvPManager.prevent-tag-in-duel", true);
        this.clxPreventDuel = configuration.getBoolean("supported-plugins.CombatLogX.prevent-duel-if-tagged", true);
        this.clxPreventTag = configuration.getBoolean("supported-plugins.CombatLogX.prevent-tag-in-duel", true);
        this.AXpreventGraves = configuration.getBoolean("supported-plugins.AXGraves.prevent-grave-in-duel", true);
        this.dcPreventDuel = configuration.getBoolean("supported-plugins.DeluxeCombat.prevent-duel-if-tagged", true);
        this.dcPreventTag = configuration.getBoolean("supported-plugins.DeluxeCombat.prevent-tag-in-duel", true);
        this.autoUnvanish = configuration.getBoolean("supported-plugins.Essentials.auto-unvanish", true);
        this.setBackLocation = configuration.getBoolean("supported-plugins.Essentials.set-back-location", true);
        this.disableSkills = configuration.getBoolean("supported-plugins.mcMMO.disable-skills-in-duel", true);
        this.fuNoPowerLoss = configuration.getBoolean("supported-plugins.FactionsUUID.no-power-loss-in-duel", true);
        this.fNoPowerLoss = configuration.getBoolean("supported-plugins.Factions.no-power-loss-in-duel", true);
        this.duelzoneEnabled = configuration.getBoolean("supported-plugins.WorldGuard.duelzone.enabled", false);
        this.duelzones = configuration.getStringList("supported-plugins.WorldGuard.duelzone.regions");
        this.myPetDespawn = configuration.getBoolean("supported-plugins.MyPet.despawn-pet-in-duel", false);
        this.preventBountyLoss = configuration.getBoolean("supported-plugins.BountyHunters.prevent-bounty-loss-in-duel", true);
        this.preventBountyLossByNotBounties = configuration.getBoolean("supported-plugins.NotBounties.prevent-bounty-loss-in-duel", true);
        this.preventKDRChange = configuration.getBoolean("supported-plugins.SimpleClans.prevent-kdr-change", true);
        this.lhWinsCmd = configuration.getString("supported-plugins.LeaderHeads.wins.menu.command", "openwins");
        this.lhWinsTitle = configuration.getString("supported-plugins.LeaderHeads.wins.menu.title", "Duel Wins");
        this.lhLossesCmd = configuration.getString("supported-plugins.LeaderHeads.losses.menu.command", "openlosses");
        this.lhLossesTitle = configuration.getString("supported-plugins.LeaderHeads.losses.menu.title", "Duel Losses");
        this.requiresClearedInventory = configuration.getBoolean("request.requires-cleared-inventory", true);
        this.preventCreativeMode = configuration.getBoolean("request.prevent-creative-mode", false);
        this.ownInventoryEnabled = configuration.getBoolean("request.use-own-inventory.enabled", true);
        this.ownInventoryDropInventoryItems = configuration.getBoolean("request.use-own-inventory.drop-inventory-items", false);
        this.ownInventoryUsePermission = configuration.getBoolean("request.use-own-inventory.use-permission", false);
        this.kitSelectingEnabled = configuration.getBoolean("request.kit-selecting.enabled", true);
        this.kitSelectingUsePermission = configuration.getBoolean("request.kit-selecting.use-permission", false);
        this.arenaSelectingEnabled = configuration.getBoolean("request.arena-selecting.enabled", true);
        this.arenaSelectingUsePermission = configuration.getBoolean("request.arena-selecting.use-permission", false);
        this.itemBettingEnabled = configuration.getBoolean("request.item-betting.enabled", true);
        this.itemBettingUsePermission = configuration.getBoolean("request.item-betting.use-permission", false);
        this.moneyBettingEnabled = configuration.getBoolean("request.money-betting.enabled", true);
        this.moneyBettingUsePermission = configuration.getBoolean("request.money-betting.use-permission", false);
        this.expiration = Math.max(configuration.getInt("request.expiration", 30), 0);
        this.maxDuration = configuration.getInt("duel.match.max-duration", -1);
        this.startCommandsEnabled = configuration.getBoolean("duel.match.start-commands.enabled", false);
        this.startCommandsQueueOnly = configuration.getBoolean("duel.match.start-commands.queue-matches-only", false);
        this.startCommands = configuration.getStringList("duel.match.start-commands.commands");
        this.endCommandsEnabled = configuration.getBoolean("duel.match.end-commands.enabled", false);
        this.endCommandsQueueOnly = configuration.getBoolean("duel.match.end-commands.queue-matches-only", false);
        this.endCommands = configuration.getStringList("duel.match.end-commands.commands");
        this.projectileHitMessageEnabled = configuration.getBoolean("duel.projectile-hit-message.enabled", true);
        this.projectileHitMessageTypes = configuration.getStringList("duel.projectile-hit-message.types");
        this.preventInventoryOpen = configuration.getBoolean("duel.prevent-inventory-open", true);
        this.protectKitItems = configuration.getBoolean("duel.protect-kit-items", true);
        this.removeEmptyBottle = configuration.getBoolean("duel.remove-empty-bottle", true);
        this.preventTpToMatchPlayers = configuration.getBoolean("duel.prevent-teleport-to-match-players", true);
        this.forceAllowCombat = configuration.getBoolean("duel.force-allow-combat", true);
        this.cancelIfMoved = configuration.getBoolean("duel.cancel-if-moved", false);
        this.blacklistedWorlds = configuration.getStringList("duel.blacklisted-worlds");
        this.teleportToLastLocation = configuration.getBoolean("duel.teleport-to-last-location", false);
        this.teleportDelay = configuration.getInt("duel.teleport-delay", 5);
        this.spawnFirework = configuration.getBoolean("duel.spawn-firework", true);
        this.arenaOnlyEndMessage = configuration.getBoolean("duel.arena-only-end-message", false);
        this.displayInventories = configuration.getBoolean("duel.display-inventories", true);
        this.preventItemDrop = configuration.getBoolean("duel.prevent-item-drop", false);
        this.clearItemsAfterMatch = configuration.getBoolean("duel.clear-items-after-duel", false);
        this.preventItemPickup = configuration.getBoolean("duel.prevent-item-pickup", true);
        this.limitTeleportEnabled = configuration.getBoolean("duel.limit-teleportation.enabled", true);
        this.distanceAllowed = configuration.getDouble("duel.limit-teleportation.distance-allowed", 5.0);
        this.blockAllCommands = configuration.getBoolean("duel.block-all-commands", false);
        this.whitelistedCommands = configuration.getStringList("duel.whitelisted-commands");
        this.blacklistedCommands = configuration.getStringList("duel.blacklisted-commands");
        this.queueBlacklistedCommands = configuration.getStringList("queue.blacklisted-commands");
        this.ratingEnabled = configuration.getBoolean("rating.enabled", true);
        this.kFactor = Math.max(configuration.getInt("rating.k-factor", 32), 1);
        this.maxDifference = Math.max(configuration.getInt("rating.max-difference", 400), 1);
        this.defaultRating = Math.max(configuration.getInt("rating.default-rating", 1400), 0);
        this.ratingQueueOnly = configuration.getBoolean("rating.queue-matches-only", true);
        this.specRequiresClearedInventory = configuration.getBoolean("spectate.requires-cleared-inventory", false);
        this.specUseSpectatorGamemode = configuration.getBoolean("spectate.use-spectator-gamemode", false);
        this.specAddInvisibilityEffect = configuration.getBoolean("spectate.add-invisibility-effect", true);
        this.specWhitelistedCommands = configuration.getStringList("spectate.whitelisted-commands");
        this.cdEnabled = configuration.getBoolean("countdown.enabled", true);
        this.preventMovement = configuration.getBoolean("countdown.prevent.movement", true);
        this.preventLaunchProjectile = configuration.getBoolean("countdown.prevent.launch-projectile", true);
        this.preventPvp = configuration.getBoolean("countdown.prevent.pvp", true);
        this.preventInteract = configuration.getBoolean("countdown.prevent.interact", true);
        this.displayKitRatings = configuration.getBoolean("stats.display-kit-ratings", true);
        this.displayNoKitRating = configuration.getBoolean("stats.display-nokit-rating", false);
        this.displayPastMatches = configuration.getBoolean("stats.display-past-matches", true);
        this.matchesToDisplay = Math.max(configuration.getInt("stats.matches-to-display", 10), 0);
        this.topUpdateInterval = (long)Math.max(configuration.getInt("top.update-interval", 5), 1) * 60L * 1000L;
        this.topWinsType = configuration.getString("top.displayed-replacers.wins.type", "Wins");
        this.topWinsIdentifier = configuration.getString("top.displayed-replacers.wins.identifier", "wins");
        this.topLossesType = configuration.getString("top.displayed-replacers.losses.type", "Losses");
        this.topLossesIdentifier = configuration.getString("top.displayed-replacers.losses.identifier", "losses");
        this.topKitType = configuration.getString("top.displayed-replacers.kit.type", "%kit%");
        this.topKitIdentifier = configuration.getString("top.displayed-replacers.kit.identifier", "rating");
        this.topNoKitType = configuration.getString("top.displayed-replacers.no-kit.type", "No Kit");
        this.topNoKitIdentifier = configuration.getString("top.displayed-replacers.no-kit.identifier", "rating");
        this.kitSelectorRows = Math.min(Math.max(configuration.getInt("guis.kit-selector.rows", 2), 1), 5);
        this.kitSelectorFillerType = configuration.getString("guis.kit-selector.space-filler-item.type", "STAINED_GLASS_PANE");
        this.kitSelectorFillerData = (short)configuration.getInt("guis.kit-selector.space-filler-item.data", 0);
        this.arenaSelectorRows = Math.min(Math.max(configuration.getInt("guis.arena-selector.rows", 3), 1), 5);
        this.arenaSelectorFillerType = configuration.getString("guis.arena-selector.space-filler-item.type", "STAINED_GLASS_PANE");
        this.arenaSelectorFillerData = (short)configuration.getInt("guis.arena-selector.space-filler-item.data", 0);
        this.settingsFillerType = configuration.getString("guis.settings.space-filler-item.type", "STAINED_GLASS_PANE");
        this.settingsFillerData = (short)configuration.getInt("guis.settings.space-filler-item.data", 0);
        this.queuesRows = Math.min(Math.max(configuration.getInt("guis.queues.rows", 3), 1), 5);
        this.queuesFillerType = configuration.getString("guis.queues.space-filler-item.type", "STAINED_GLASS_PANE");
        this.queuesFillerData = (short)configuration.getInt("guis.queues.space-filler-item.data", 0);
        this.inheritKitItemType = configuration.getBoolean("guis.queues.inherit-kit-item-type", true);
        this.soupHeartsToRegen = Math.max(configuration.getDouble("soup.hearts-to-regen", 3.5), 0.0);
        this.soupRemoveEmptyBowl = configuration.getBoolean("soup.remove-empty-bowl", true);
        this.soupCancelIfAlreadyFull = configuration.getBoolean("soup.cancel-if-already-full", true);
        this.fireworkColour = configuration.getString("firework.colour", "AQUA");
        this.fireworkType = configuration.getString("firework.type", "BALL_LARGE");
        this.stayUpToDate = configuration.getBoolean("stay-up-to-date", true);
        this.disableEnderpearlInEndgame = configuration.getBoolean("disable-enderpearl-in-endgame", true);
        this.disableMovementInEndgame = configuration.getBoolean("disable-movement-in-endgame", false);
        this.sendDeathMessages = configuration.getBoolean("duel.send-death-messages", true);
        this.partyInviteExpiration = configuration.getInt("party.invite-expiration", 30);
        this.partyAutoDisbandAfter = configuration.getInt("party.auto-disband-after", 10);
        this.partyMaxSize = configuration.getInt("party.max-size", 10);
        this.partySameSizeOnly = configuration.getBoolean("party.same-size-only", true);
        this.cdDuelMessages = configuration.getStringList("countdown.duel.messages");
        this.cdDuelTitles = configuration.getStringList("countdown.duel.titles");
        this.cdPartyDuelMessages = configuration.getStringList("countdown.party-duel.messages");
        this.cdPartyDuelTitles = configuration.getStringList("countdown.party-duel.titles");
        ConfigurationSection sounds = configuration.getConfigurationSection("sounds");
        if (sounds != null) {
            for (String name : sounds.getKeys(false)) {
                ConfigurationSection sound = sounds.getConfigurationSection(name);
                Sound type = EnumUtil.getByName(sound.getString("type"), Sound.class);
                if (type == null) continue;
                List triggers = sound.getStringList("trigger-messages");
                MessageSound messageSound = new MessageSound(this, type, sound.getDouble("pitch"), sound.getDouble("volume"), triggers);
                this.sounds.put(name, messageSound);
                triggers.forEach(message -> this.messageToSounds.put(message, (Object)messageSound));
            }
        }
    }

    public void playSound(Player player, String message) {
        this.sounds.values().stream().filter(sound -> sound.getMessages().contains(message)).forEach(sound -> player.playSound(player.getLocation(), sound.getType(), sound.getVolume(), sound.getPitch()));
    }

    public MessageSound getSound(String name) {
        return this.sounds.get(name);
    }

    public Set<String> getSounds() {
        return this.sounds.keySet();
    }

    @Generated
    public int getVersion() {
        return this.version;
    }

    @Generated
    public boolean isCheckForUpdates() {
        return this.checkForUpdates;
    }

    @Generated
    public boolean isCtpPreventDuel() {
        return this.ctpPreventDuel;
    }

    @Generated
    public boolean isCtpPreventTag() {
        return this.ctpPreventTag;
    }

    @Generated
    public boolean isPmPreventDuel() {
        return this.pmPreventDuel;
    }

    @Generated
    public boolean isPmPreventTag() {
        return this.pmPreventTag;
    }

    @Generated
    public boolean isClxPreventDuel() {
        return this.clxPreventDuel;
    }

    @Generated
    public boolean isClxPreventTag() {
        return this.clxPreventTag;
    }

    @Generated
    public boolean isDcPreventDuel() {
        return this.dcPreventDuel;
    }

    @Generated
    public boolean isDcPreventTag() {
        return this.dcPreventTag;
    }

    @Generated
    public boolean isAutoUnvanish() {
        return this.autoUnvanish;
    }

    @Generated
    public boolean isSetBackLocation() {
        return this.setBackLocation;
    }

    @Generated
    public boolean isDisableSkills() {
        return this.disableSkills;
    }

    @Generated
    public boolean isFuNoPowerLoss() {
        return this.fuNoPowerLoss;
    }

    @Generated
    public boolean isFNoPowerLoss() {
        return this.fNoPowerLoss;
    }

    @Generated
    public boolean isDuelzoneEnabled() {
        return this.duelzoneEnabled;
    }

    @Generated
    public List<String> getDuelzones() {
        return this.duelzones;
    }

    @Generated
    public boolean isMyPetDespawn() {
        return this.myPetDespawn;
    }

    @Generated
    public boolean isPreventBountyLoss() {
        return this.preventBountyLoss;
    }

    @Generated
    public boolean isPreventBountyLossByNotBounties() {
        return this.preventBountyLossByNotBounties;
    }

    @Generated
    public boolean isPreventKDRChange() {
        return this.preventKDRChange;
    }

    @Generated
    public String getLhWinsCmd() {
        return this.lhWinsCmd;
    }

    @Generated
    public String getLhWinsTitle() {
        return this.lhWinsTitle;
    }

    @Generated
    public String getLhLossesCmd() {
        return this.lhLossesCmd;
    }

    @Generated
    public String getLhLossesTitle() {
        return this.lhLossesTitle;
    }

    @Generated
    public boolean isRequiresClearedInventory() {
        return this.requiresClearedInventory;
    }

    @Generated
    public boolean isPreventCreativeMode() {
        return this.preventCreativeMode;
    }

    @Generated
    public boolean isOwnInventoryEnabled() {
        return this.ownInventoryEnabled;
    }

    @Generated
    public boolean isOwnInventoryDropInventoryItems() {
        return this.ownInventoryDropInventoryItems;
    }

    @Generated
    public boolean isOwnInventoryUsePermission() {
        return this.ownInventoryUsePermission;
    }

    @Generated
    public boolean isKitSelectingEnabled() {
        return this.kitSelectingEnabled;
    }

    @Generated
    public boolean isKitSelectingUsePermission() {
        return this.kitSelectingUsePermission;
    }

    @Generated
    public boolean isArenaSelectingEnabled() {
        return this.arenaSelectingEnabled;
    }

    @Generated
    public boolean isArenaSelectingUsePermission() {
        return this.arenaSelectingUsePermission;
    }

    @Generated
    public boolean isItemBettingEnabled() {
        return this.itemBettingEnabled;
    }

    @Generated
    public boolean isItemBettingUsePermission() {
        return this.itemBettingUsePermission;
    }

    @Generated
    public boolean isMoneyBettingEnabled() {
        return this.moneyBettingEnabled;
    }

    @Generated
    public boolean isMoneyBettingUsePermission() {
        return this.moneyBettingUsePermission;
    }

    @Generated
    public int getExpiration() {
        return this.expiration;
    }

    @Generated
    public int getMaxDuration() {
        return this.maxDuration;
    }

    @Generated
    public boolean isStartCommandsEnabled() {
        return this.startCommandsEnabled;
    }

    @Generated
    public boolean isStartCommandsQueueOnly() {
        return this.startCommandsQueueOnly;
    }

    @Generated
    public List<String> getStartCommands() {
        return this.startCommands;
    }

    @Generated
    public boolean isEndCommandsEnabled() {
        return this.endCommandsEnabled;
    }

    @Generated
    public boolean isEndCommandsQueueOnly() {
        return this.endCommandsQueueOnly;
    }

    @Generated
    public List<String> getEndCommands() {
        return this.endCommands;
    }

    @Generated
    public boolean isProjectileHitMessageEnabled() {
        return this.projectileHitMessageEnabled;
    }

    @Generated
    public List<String> getProjectileHitMessageTypes() {
        return this.projectileHitMessageTypes;
    }

    @Generated
    public boolean isPreventInventoryOpen() {
        return this.preventInventoryOpen;
    }

    @Generated
    public boolean isProtectKitItems() {
        return this.protectKitItems;
    }

    @Generated
    public boolean isRemoveEmptyBottle() {
        return this.removeEmptyBottle;
    }

    @Generated
    public boolean isPreventTpToMatchPlayers() {
        return this.preventTpToMatchPlayers;
    }

    @Generated
    public boolean isForceAllowCombat() {
        return this.forceAllowCombat;
    }

    @Generated
    public boolean isCancelIfMoved() {
        return this.cancelIfMoved;
    }

    @Generated
    public List<String> getBlacklistedWorlds() {
        return this.blacklistedWorlds;
    }

    @Generated
    public boolean isTeleportToLastLocation() {
        return this.teleportToLastLocation;
    }

    @Generated
    public int getTeleportDelay() {
        return this.teleportDelay;
    }

    @Generated
    public boolean isSpawnFirework() {
        return this.spawnFirework;
    }

    @Generated
    public boolean isArenaOnlyEndMessage() {
        return this.arenaOnlyEndMessage;
    }

    @Generated
    public boolean isDisplayInventories() {
        return this.displayInventories;
    }

    @Generated
    public boolean isPreventItemDrop() {
        return this.preventItemDrop;
    }

    @Generated
    public boolean isPreventItemPickup() {
        return this.preventItemPickup;
    }

    @Generated
    public boolean isLimitTeleportEnabled() {
        return this.limitTeleportEnabled;
    }

    @Generated
    public double getDistanceAllowed() {
        return this.distanceAllowed;
    }

    @Generated
    public boolean isBlockAllCommands() {
        return this.blockAllCommands;
    }

    @Generated
    public List<String> getWhitelistedCommands() {
        return this.whitelistedCommands;
    }

    @Generated
    public List<String> getBlacklistedCommands() {
        return this.blacklistedCommands;
    }

    @Generated
    public List<String> getQueueBlacklistedCommands() {
        return this.queueBlacklistedCommands;
    }

    @Generated
    public boolean isRatingEnabled() {
        return this.ratingEnabled;
    }

    @Generated
    public int getKFactor() {
        return this.kFactor;
    }

    @Generated
    public int getMaxDifference() {
        return this.maxDifference;
    }

    @Generated
    public int getDefaultRating() {
        return this.defaultRating;
    }

    @Generated
    public boolean isRatingQueueOnly() {
        return this.ratingQueueOnly;
    }

    @Generated
    public boolean isSpecRequiresClearedInventory() {
        return this.specRequiresClearedInventory;
    }

    @Generated
    public boolean isSpecUseSpectatorGamemode() {
        return this.specUseSpectatorGamemode;
    }

    @Generated
    public boolean isSpecAddInvisibilityEffect() {
        return this.specAddInvisibilityEffect;
    }

    @Generated
    public List<String> getSpecWhitelistedCommands() {
        return this.specWhitelistedCommands;
    }

    @Generated
    public boolean isCdEnabled() {
        return this.cdEnabled;
    }

    @Generated
    public boolean isPreventMovement() {
        return this.preventMovement;
    }

    @Generated
    public boolean isPreventLaunchProjectile() {
        return this.preventLaunchProjectile;
    }

    @Generated
    public boolean isPreventPvp() {
        return this.preventPvp;
    }

    @Generated
    public boolean isPreventInteract() {
        return this.preventInteract;
    }

    @Generated
    public boolean isDisplayKitRatings() {
        return this.displayKitRatings;
    }

    @Generated
    public boolean isDisplayNoKitRating() {
        return this.displayNoKitRating;
    }

    @Generated
    public boolean isDisplayPastMatches() {
        return this.displayPastMatches;
    }

    @Generated
    public int getMatchesToDisplay() {
        return this.matchesToDisplay;
    }

    @Generated
    public long getTopUpdateInterval() {
        return this.topUpdateInterval;
    }

    @Generated
    public String getTopWinsType() {
        return this.topWinsType;
    }

    @Generated
    public String getTopWinsIdentifier() {
        return this.topWinsIdentifier;
    }

    @Generated
    public String getTopLossesType() {
        return this.topLossesType;
    }

    @Generated
    public String getTopLossesIdentifier() {
        return this.topLossesIdentifier;
    }

    @Generated
    public String getTopKitType() {
        return this.topKitType;
    }

    @Generated
    public String getTopKitIdentifier() {
        return this.topKitIdentifier;
    }

    @Generated
    public String getTopNoKitType() {
        return this.topNoKitType;
    }

    @Generated
    public String getTopNoKitIdentifier() {
        return this.topNoKitIdentifier;
    }

    @Generated
    public int getKitSelectorRows() {
        return this.kitSelectorRows;
    }

    @Generated
    public String getKitSelectorFillerType() {
        return this.kitSelectorFillerType;
    }

    @Generated
    public short getKitSelectorFillerData() {
        return this.kitSelectorFillerData;
    }

    @Generated
    public int getArenaSelectorRows() {
        return this.arenaSelectorRows;
    }

    @Generated
    public String getArenaSelectorFillerType() {
        return this.arenaSelectorFillerType;
    }

    @Generated
    public short getArenaSelectorFillerData() {
        return this.arenaSelectorFillerData;
    }

    @Generated
    public String getSettingsFillerType() {
        return this.settingsFillerType;
    }

    @Generated
    public short getSettingsFillerData() {
        return this.settingsFillerData;
    }

    @Generated
    public int getQueuesRows() {
        return this.queuesRows;
    }

    @Generated
    public String getQueuesFillerType() {
        return this.queuesFillerType;
    }

    @Generated
    public short getQueuesFillerData() {
        return this.queuesFillerData;
    }

    @Generated
    public boolean isInheritKitItemType() {
        return this.inheritKitItemType;
    }

    @Generated
    public double getSoupHeartsToRegen() {
        return this.soupHeartsToRegen;
    }

    @Generated
    public boolean isSoupRemoveEmptyBowl() {
        return this.soupRemoveEmptyBowl;
    }

    @Generated
    public boolean isSoupCancelIfAlreadyFull() {
        return this.soupCancelIfAlreadyFull;
    }

    @Generated
    public String getFireworkColour() {
        return this.fireworkColour;
    }

    @Generated
    public String getFireworkType() {
        return this.fireworkType;
    }

    @Generated
    public boolean isClearItemsAfterMatch() {
        return this.clearItemsAfterMatch;
    }

    @Generated
    public boolean isStayUpToDate() {
        return this.stayUpToDate;
    }

    @Generated
    public boolean isDisableEnderpearlInEndgame() {
        return this.disableEnderpearlInEndgame;
    }

    @Generated
    public boolean isDisableMovementInEndgame() {
        return this.disableMovementInEndgame;
    }

    @Generated
    public boolean isSendDeathMessages() {
        return this.sendDeathMessages;
    }

    @Generated
    public int getPartyInviteExpiration() {
        return this.partyInviteExpiration;
    }

    @Generated
    public int getPartyAutoDisbandAfter() {
        return this.partyAutoDisbandAfter;
    }

    @Generated
    public int getPartyMaxSize() {
        return this.partyMaxSize;
    }

    @Generated
    public boolean isPartySameSizeOnly() {
        return this.partySameSizeOnly;
    }

    @Generated
    public List<String> getCdDuelMessages() {
        return this.cdDuelMessages;
    }

    @Generated
    public List<String> getCdDuelTitles() {
        return this.cdDuelTitles;
    }

    @Generated
    public List<String> getCdPartyDuelMessages() {
        return this.cdPartyDuelMessages;
    }

    @Generated
    public List<String> getCdPartyDuelTitles() {
        return this.cdPartyDuelTitles;
    }

    @Generated
    public boolean isAXpreventGraves() {
        return this.AXpreventGraves;
    }

    @Generated
    public String getUserNotFound() {
        return this.userNotFound;
    }

    @Generated
    public String getNotInMatch() {
        return this.notInMatch;
    }

    @Generated
    public String getDurationFormat() {
        return this.durationFormat;
    }

    @Generated
    public String getNoKit() {
        return this.noKit;
    }

    @Generated
    public String getNoOpponent() {
        return this.noOpponent;
    }

    public class MessageSound {
        private final Sound type;
        private final float pitch;
        private final float volume;
        private final List<String> messages;

        MessageSound(Config this$0, Sound type, double pitch, double volume, List<String> messages) {
            this.type = type;
            this.pitch = (float)pitch;
            this.volume = (float)volume;
            this.messages = messages;
        }

        @Generated
        public Sound getType() {
            return this.type;
        }

        @Generated
        public float getPitch() {
            return this.pitch;
        }

        @Generated
        public float getVolume() {
            return this.volume;
        }

        @Generated
        public List<String> getMessages() {
            return this.messages;
        }
    }
}

