/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.countdown;

import com.meteordevelopments.duels-optimised.shaded.morepaperlib.scheduling.ScheduledTask;
import com.meteordevelopments.duels.DuelsPlugin;
import com.meteordevelopments.duels.arena.ArenaImpl;
import com.meteordevelopments.duels.config.Config;
import com.meteordevelopments.duels.config.Lang;
import com.meteordevelopments.duels.data.UserData;
import com.meteordevelopments.duels.data.UserManagerImpl;
import com.meteordevelopments.duels.match.DuelMatch;
import com.meteordevelopments.duels.util.StringUtil;
import com.meteordevelopments.duels.util.compat.Titles;
import com.meteordevelopments.duels.util.function.Pair;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;

public class DuelCountdown
extends BukkitRunnable {
    protected final Config config;
    protected final Lang lang;
    protected final UserManagerImpl userManager;
    protected final ArenaImpl arena;
    protected final DuelMatch match;
    private final List<String> messages;
    private final List<String> titles;
    private final Map<UUID, Pair<String, Integer>> info = new HashMap<UUID, Pair<String, Integer>>();
    private int index = 0;
    private final AtomicReference<ScheduledTask> scheduledTask = new AtomicReference();

    protected DuelCountdown(DuelsPlugin plugin, ArenaImpl arena, DuelMatch match, List<String> messages, List<String> titles) {
        this.config = plugin.getConfiguration();
        this.lang = plugin.getLang();
        this.userManager = plugin.getUserManager();
        this.arena = arena;
        this.match = match;
        this.titles = titles;
        this.messages = messages;
    }

    public DuelCountdown(DuelsPlugin plugin, ArenaImpl arena, DuelMatch match) {
        this(plugin, arena, match, plugin.getConfiguration().getCdDuelMessages(), plugin.getConfiguration().getCdDuelTitles());
        match.getAllPlayers().forEach(player -> {
            Player opponent = arena.getOpponent((Player)player);
            UserData user = this.userManager.get(opponent);
            if (user == null) {
                return;
            }
            this.info.put(player.getUniqueId(), new Pair<String, Integer>(opponent.getName(), user.getRatingUnsafe(match.getKit())));
        });
    }

    protected void sendMessage(String rawMessage, String message, String title) {
        String kitName = this.match.getKit() != null ? this.match.getKit().getName() : this.lang.getMessage("GENERAL.none");
        this.arena.getPlayers().forEach(player -> {
            this.config.playSound((Player)player, rawMessage);
            Pair<String, Integer> info = this.info.get(player.getUniqueId());
            if (info != null) {
                player.sendMessage(message.replace("%opponent%", info.getKey()).replace("%opponent_rating%", String.valueOf(info.getValue())).replace("%kit%", kitName).replace("%arena%", this.arena.getName()));
            } else {
                player.sendMessage(message);
            }
            if (title != null) {
                Titles.send(player, title, null, 0, 20, 50);
            }
        });
    }

    public void run() {
        if (!this.arena.isUsed() || this.index >= this.messages.size()) {
            this.arena.setCountdown(null);
            ScheduledTask task = this.scheduledTask.get();
            if (task != null) {
                task.cancel();
            }
            return;
        }
        String rawMessage = this.messages.get(this.index);
        String message = StringUtil.color(rawMessage);
        String title = this.titles.size() >= this.index + 1 ? this.titles.get(this.index) : null;
        this.sendMessage(rawMessage, message, title);
        ++this.index;
    }

    public void startCountdown(long delay, long period) {
        ScheduledTask task = DuelsPlugin.getMorePaperLib().scheduling().asyncScheduler().runAtFixedRate((Runnable)((Object)this), Duration.ofMillis(delay * 50L), Duration.ofMillis(period * 50L));
        this.scheduledTask.set(task);
    }
}

