/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.data;

import com.meteordevelopments.duels.DuelsPlugin;
import com.meteordevelopments.duels.arena.ArenaImpl;
import com.meteordevelopments.duels.data.LocationData;
import com.meteordevelopments.duels.kit.KitImpl;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.bukkit.Location;

public class ArenaData {
    private String name;
    private boolean disabled;
    private Set<String> kits = new HashSet<String>();
    private Map<Integer, LocationData> positions = new HashMap<Integer, LocationData>();

    private ArenaData() {
    }

    public ArenaData(ArenaImpl arena) {
        this.name = arena.getName();
        this.disabled = arena.isDisabled();
        arena.getKits().forEach(kit -> this.kits.add(kit.getName()));
        arena.getPositions().entrySet().stream().filter(entry -> ((Location)entry.getValue()).getWorld() != null).forEach(entry -> this.positions.put((Integer)entry.getKey(), LocationData.fromLocation((Location)entry.getValue())));
    }

    public ArenaImpl toArena(DuelsPlugin plugin) {
        ArenaImpl arena = new ArenaImpl(plugin, this.name, this.disabled);
        this.kits.stream().map(name -> plugin.getKitManager().get((String)name)).filter(Objects::nonNull).forEach(kit -> arena.getKits().add((KitImpl)kit));
        this.positions.forEach((key, value) -> arena.getPositions().put((Integer)key, value.toLocation()));
        arena.refreshGui(arena.isAvailable());
        return arena;
    }

    @Generated
    public String getName() {
        return this.name;
    }
}

