/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.data;

import com.meteordevelopments.duels.data.ItemData;
import com.meteordevelopments.duels.data.LocationData;
import com.meteordevelopments.duels.data.PotionEffectData;
import com.meteordevelopments.duels.player.PlayerInfo;
import com.meteordevelopments.duels.util.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bukkit.inventory.ItemStack;

public class PlayerData {
    private static final transient String ITEM_LOAD_FAILURE = "Could not load item %s!";
    private Map<String, Map<Integer, ItemData>> items = new HashMap<String, Map<Integer, ItemData>>();
    private Collection<PotionEffectData> effects = new ArrayList<PotionEffectData>();
    private double health;
    private float experience;
    private int level;
    private int hunger;
    private LocationData location;
    private boolean restoreExperience;
    private List<ItemData> extra = new ArrayList<ItemData>();

    private PlayerData() {
    }

    private PlayerData(PlayerInfo info) {
        this.health = info.getHealth();
        this.experience = info.getExperience();
        this.level = info.getLevel();
        this.hunger = info.getHunger();
        this.location = LocationData.fromLocation(info.getLocation());
        this.restoreExperience = info.isRestoreExperience();
        for (Map.Entry<String, Map<Integer, ItemStack>> entry : info.getItems().entrySet()) {
            HashMap data = new HashMap();
            entry.getValue().entrySet().stream().filter(value -> Objects.nonNull(value.getValue())).forEach(value -> data.put((Integer)value.getKey(), ItemData.fromItemStack((ItemStack)value.getValue())));
            this.items.put(entry.getKey(), data);
        }
        info.getExtra().forEach(item -> this.extra.add(ItemData.fromItemStack(item)));
    }

    public static PlayerData fromPlayerInfo(PlayerInfo info) {
        return new PlayerData(info);
    }

    public PlayerInfo toPlayerInfo() {
        PlayerInfo info = new PlayerInfo(this.effects.stream().map(PotionEffectData::toPotionEffect).filter(Objects::nonNull).collect(Collectors.toList()), this.health, this.experience, this.level, this.hunger, this.location.toLocation(), this.restoreExperience);
        for (Map.Entry<String, Map<Integer, ItemData>> entry : this.items.entrySet()) {
            HashMap data2 = new HashMap();
            entry.getValue().forEach((slot, itemData) -> {
                ItemStack item = itemData.toItemStack(false);
                if (item == null) {
                    Log.warn(String.format(ITEM_LOAD_FAILURE, itemData.toString()));
                    return;
                }
                data2.put(slot, item);
            });
            info.getItems().put(entry.getKey(), data2);
        }
        info.getExtra().addAll(this.extra.stream().map(data -> data.toItemStack(false)).filter(Objects::nonNull).collect(Collectors.toList()));
        return info;
    }
}

