/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.data;

import com.google.common.collect.Lists;
import com.meteordevelopments.duels-optimised.shaded.morepaperlib.scheduling.ScheduledTask;
import com.meteordevelopments.duels.DuelsPlugin;
import com.meteordevelopments.duels.api.event.user.UserCreateEvent;
import com.meteordevelopments.duels.api.kit.Kit;
import com.meteordevelopments.duels.api.user.User;
import com.meteordevelopments.duels.api.user.UserManager;
import com.meteordevelopments.duels.config.Config;
import com.meteordevelopments.duels.config.Lang;
import com.meteordevelopments.duels.data.MatchData;
import com.meteordevelopments.duels.data.UserData;
import com.meteordevelopments.duels.kit.KitImpl;
import com.meteordevelopments.duels.match.DuelMatch;
import com.meteordevelopments.duels.match.party.PartyDuelMatch;
import com.meteordevelopments.duels.party.Party;
import com.meteordevelopments.duels.util.DateUtil;
import com.meteordevelopments.duels.util.Loadable;
import com.meteordevelopments.duels.util.Log;
import com.meteordevelopments.duels.util.NumberUtil;
import com.meteordevelopments.duels.util.StringUtil;
import com.meteordevelopments.duels.util.UUIDUtil;
import com.meteordevelopments.duels.util.json.JsonUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UserManagerImpl
implements Loadable,
Listener,
UserManager {
    private static final Calendar GREGORIAN_CALENDAR = new GregorianCalendar();
    private static final String ADMIN_UPDATE_MESSAGE = "&9[Duels] &bDuels &fv%s &7is now available for download! Download at: &c%s";
    private final DuelsPlugin plugin;
    private final Config config;
    private final Lang lang;
    private final File folder;
    private final Map<UUID, UserData> users = new ConcurrentHashMap<UUID, UserData>();
    private final Map<String, UUID> names = new ConcurrentHashMap<String, UUID>();
    private final Map<Kit, UserManager.TopEntry> topRatings = new ConcurrentHashMap<Kit, UserManager.TopEntry>();
    private volatile int defaultRating;
    private volatile int matchesToDisplay;
    private volatile boolean loaded;
    private volatile UserManager.TopEntry wins;
    private volatile UserManager.TopEntry losses;
    private volatile UserManager.TopEntry noKit;
    private ScheduledTask topTask;

    public UserManagerImpl(DuelsPlugin plugin) {
        this.plugin = plugin;
        this.config = plugin.getConfiguration();
        this.lang = plugin.getLang();
        this.folder = new File(plugin.getDataFolder(), "users");
        if (!this.folder.exists()) {
            this.folder.mkdir();
        }
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @Override
    public void handleLoad() {
        this.defaultRating = this.config.getDefaultRating();
        this.matchesToDisplay = this.config.getMatchesToDisplay();
        if (this.matchesToDisplay < 0) {
            this.matchesToDisplay = 0;
        }
        this.plugin.doAsync(() -> {
            File[] files = this.folder.listFiles();
            if (files != null && files.length > 0) {
                for (File file : files) {
                    String name;
                    UUID uuid;
                    String fileName = file.getName();
                    if (!fileName.endsWith(".json") || (uuid = UUIDUtil.parseUUID(name = fileName.substring(0, fileName.length() - 5))) == null || this.users.containsKey(uuid)) continue;
                    try (InputStreamReader reader = new InputStreamReader(new FileInputStream(file));){
                        UserData user = JsonUtil.getObjectMapper().readValue((Reader)reader, UserData.class);
                        if (user == null) {
                            Log.warn(this, "Could not load userdata from file: " + fileName);
                            continue;
                        }
                        user.folder = this.folder;
                        user.defaultRating = this.defaultRating;
                        user.matchesToDisplay = this.matchesToDisplay;
                        user.refreshMatches();
                        this.names.putIfAbsent(user.getName().toLowerCase(), uuid);
                        this.users.putIfAbsent(uuid, user);
                    }
                    catch (IOException ex) {
                        Log.error(this, "Could not load userdata from file: " + fileName, ex);
                    }
                }
            }
            this.loaded = true;
        });
        this.topTask = this.plugin.doSyncRepeat(() -> {
            List<Kit> kits = this.plugin.getKitManager().getKits();
            this.plugin.doAsync(() -> {
                if (!this.loaded) {
                    return;
                }
                UserManager.TopEntry top = this.get(this.config.getTopUpdateInterval(), this.wins, User::getWins, this.config.getTopWinsType(), this.config.getTopWinsIdentifier());
                if (top != null) {
                    this.wins = top;
                }
                if ((top = this.get(this.config.getTopUpdateInterval(), this.losses, User::getLosses, this.config.getTopLossesType(), this.config.getTopLossesIdentifier())) != null) {
                    this.losses = top;
                }
                if ((top = this.get(this.config.getTopUpdateInterval(), this.noKit, User::getRating, this.config.getTopNoKitType(), this.config.getTopNoKitIdentifier())) != null) {
                    this.noKit = top;
                }
                this.topRatings.keySet().removeIf(kit -> !kits.contains(kit));
                for (Kit kit2 : kits) {
                    UserManager.TopEntry entry = this.topRatings.get(kit2);
                    top = this.get(this.config.getTopUpdateInterval(), entry, user -> user.getRating(kit2), this.config.getTopKitType().replace("%kit%", kit2.getName()), this.config.getTopKitIdentifier());
                    if (top == null) continue;
                    this.topRatings.put(kit2, top);
                }
            });
        }, 100L, 20L);
    }

    @Override
    public void handleUnload() {
        this.plugin.cancelTask(this.topTask);
        this.loaded = false;
        this.saveUsers(Bukkit.getOnlinePlayers());
        this.users.clear();
        this.names.clear();
        this.topRatings.clear();
    }

    @Override
    @Nullable
    public UserData get(@NotNull String name) {
        Objects.requireNonNull(name, "name");
        UUID uuid = this.names.get(name.toLowerCase());
        return uuid != null ? this.get(uuid) : null;
    }

    @Override
    @Nullable
    public UserData get(@NotNull UUID uuid) {
        Objects.requireNonNull(uuid, "uuid");
        return this.users.get(uuid);
    }

    @Override
    @Nullable
    public UserData get(@NotNull Player player) {
        Objects.requireNonNull(player, "player");
        return this.get(player.getUniqueId());
    }

    @Override
    @Nullable
    public UserManager.TopEntry getTopWins() {
        return this.wins;
    }

    @Override
    @Nullable
    public UserManager.TopEntry getTopLosses() {
        return this.losses;
    }

    @Override
    @Nullable
    public UserManager.TopEntry getTopRatings() {
        return this.noKit;
    }

    @Override
    @Nullable
    public UserManager.TopEntry getTopRatings(@NotNull Kit kit) {
        Objects.requireNonNull(kit, "kit");
        return this.topRatings.get(kit);
    }

    public String getNextUpdate(long creation) {
        return DateUtil.format((creation + this.config.getTopUpdateInterval() - System.currentTimeMillis()) / 1000L);
    }

    private UserManager.TopEntry get(long interval, UserManager.TopEntry previous, Function<User, Integer> function, String type, String identifier) {
        if (previous == null || System.currentTimeMillis() - previous.getCreation() >= interval) {
            return new UserManager.TopEntry(type, identifier, this.subList(this.sorted(function)));
        }
        return null;
    }

    private List<UserManager.TopData> subList(List<UserManager.TopData> list) {
        return Collections.unmodifiableList(Lists.newArrayList(list.size() > 10 ? list.subList(0, 10) : list));
    }

    private List<UserManager.TopData> sorted(Function<User, Integer> function) {
        return this.users.values().stream().map(data -> new UserManager.TopData(data.getUuid(), data.getName(), (Integer)function.apply((User)data))).sorted(Comparator.reverseOrder()).collect(Collectors.toList());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private UserData tryLoad(Player player) {
        File file = new File(this.folder, String.valueOf(player.getUniqueId()) + ".json");
        if (!file.exists()) {
            UserData user2 = new UserData(this.folder, this.defaultRating, this.matchesToDisplay, player);
            this.plugin.doSync(() -> Bukkit.getPluginManager().callEvent((Event)new UserCreateEvent(user2)));
            return user2;
        }
        try (InputStreamReader reader = new InputStreamReader(new FileInputStream(file));){
            UserData user = JsonUtil.getObjectMapper().readValue((Reader)reader, UserData.class);
            if (user == null) {
                UserData userData = null;
                return userData;
            }
            user.folder = this.folder;
            user.defaultRating = this.defaultRating;
            user.matchesToDisplay = this.matchesToDisplay;
            user.refreshMatches();
            if (!player.getName().equals(user.getName())) {
                user.setName(player.getName());
            }
            UserData userData = user;
            return userData;
        }
        catch (IOException ex) {
            Log.error(this, "An error occured while loading userdata of " + player.getName() + "!", ex);
            return null;
        }
    }

    private void saveUsers(Collection<? extends Player> players) {
        for (Player player : players) {
            UserData user = this.users.remove(player.getUniqueId());
            if (user == null) continue;
            user.trySave();
        }
    }

    @EventHandler
    public void on(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        this.plugin.doSyncAfter(() -> {
            if (this.plugin.getUpdateManager() != null && this.plugin.getUpdateManager().updateIsAvailable() && (player.isOp() || player.hasPermission("duels.admin"))) {
                player.sendMessage(StringUtil.color(String.format(ADMIN_UPDATE_MESSAGE, this.plugin.getUpdateManager().getLatestVersion(), this.plugin.getDescription().getWebsite())));
            }
        }, 5L);
        UserData user = this.users.get(player.getUniqueId());
        if (user != null) {
            if (!player.getName().equals(user.getName())) {
                user.setName(player.getName());
                this.names.put(player.getName().toLowerCase(), player.getUniqueId());
            }
            return;
        }
        this.plugin.doAsync(() -> {
            UserData data = this.tryLoad(player);
            if (data == null) {
                this.lang.sendMessage((CommandSender)player, "ERROR.data.load-failure", new Object[0]);
                return;
            }
            this.names.put(player.getName().toLowerCase(), player.getUniqueId());
            this.users.put(player.getUniqueId(), data);
        });
    }

    @EventHandler
    public void on(PlayerQuitEvent event) {
        UUID uuid = event.getPlayer().getUniqueId();
        UserData user = this.users.remove(uuid);
        if (user != null) {
            this.plugin.doAsync(() -> {
                user.trySave();
                this.users.put(uuid, user);
            });
        }
    }

    public void handleMatchEnd(DuelMatch match, Set<Player> winners) {
        String message;
        String kitName;
        Player winner = winners.iterator().next();
        String string = kitName = match.getKit() != null ? match.getKit().getName() : this.lang.getMessage("GENERAL.none");
        if (!(match instanceof PartyDuelMatch)) {
            long duration = System.currentTimeMillis() - match.getStart();
            long time = GREGORIAN_CALENDAR.getTimeInMillis();
            Player loser = match.getArena().getOpponent(winner);
            double health = Math.ceil(winner.getHealth()) * 0.5;
            MatchData matchData = new MatchData(winner.getName(), loser.getName(), kitName, time, duration, health);
            UserData winnerData = this.get(winner);
            UserData loserData = this.get(loser);
            if (winnerData != null && loserData != null) {
                winnerData.addWin();
                loserData.addLoss();
                winnerData.addMatch(matchData);
                loserData.addMatch(matchData);
                KitImpl kit = match.getKit();
                int winnerRating = winnerData.getRatingUnsafe(kit);
                int loserRating = loserData.getRatingUnsafe(kit);
                int change = 0;
                if (this.config.isRatingEnabled() && (match.isFromQueue() || !this.config.isRatingQueueOnly())) {
                    change = NumberUtil.getChange(this.config.getKFactor(), winnerRating, loserRating);
                    winnerData.setRating(kit, winnerRating += change);
                    loserData.setRating(kit, loserRating -= change);
                }
                message = this.lang.getMessage("DUEL.on-end.opponent-defeat", "winner", winner.getName(), "loser", loser.getName(), "health", matchData.getHealth(), "kit", kitName, "arena", match.getArena().getName(), "winner_rating", winnerRating, "loser_rating", loserRating, "change", change);
            } else {
                message = null;
            }
        } else {
            PartyDuelMatch partyMatch = (PartyDuelMatch)match;
            Party winnerParty = partyMatch.getPlayerToParty().get(winner);
            Party loserParty = match.getArena().getOpponent(winnerParty);
            message = this.lang.getMessage("DUEL.on-end.party-opponent-defeat", "winners", StringUtil.join(partyMatch.getNames(winnerParty), ", "), "losers", StringUtil.join(partyMatch.getNames(loserParty), ", "), "kit", kitName, "arena", match.getArena().getName());
        }
        if (message == null) {
            return;
        }
        if (this.config.isArenaOnlyEndMessage()) {
            match.getArena().broadcast(message);
        } else {
            for (Player player : Bukkit.getOnlinePlayers()) {
                player.sendMessage(message);
            }
        }
    }

    @Override
    @Generated
    public boolean isLoaded() {
        return this.loaded;
    }

    @Generated
    public UserManager.TopEntry getWins() {
        return this.wins;
    }

    @Generated
    public UserManager.TopEntry getLosses() {
        return this.losses;
    }

    @Generated
    public UserManager.TopEntry getNoKit() {
        return this.noKit;
    }
}

