/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.extension;

import com.google.common.io.ByteStreams;
import com.meteordevelopments.duels.api.extension.DuelsExtension;
import com.meteordevelopments.duels.extension.ExtensionInfo;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import lombok.Generated;

public class ExtensionClassLoader
extends URLClassLoader {
    private final JarFile jar;
    private final Manifest manifest;
    private final URL url;
    private final Map<String, Class<?>> classes = new ConcurrentHashMap();
    private final DuelsExtension extension;

    ExtensionClassLoader(File file, ExtensionInfo info, ClassLoader parent) throws Exception {
        super(new URL[]{file.toURI().toURL()}, parent);
        this.jar = new JarFile(file);
        this.manifest = this.jar.getManifest();
        this.url = file.toURI().toURL();
        Class<?> mainClass = Class.forName(info.getMain(), true, this);
        if (!DuelsExtension.class.isAssignableFrom(mainClass)) {
            throw new RuntimeException(mainClass.getName() + " does not extend DuelsExtension");
        }
        this.extension = mainClass.asSubclass(DuelsExtension.class).newInstance();
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        String path;
        JarEntry entry;
        Class<?> result = this.classes.get(name);
        if (result == null && (entry = this.jar.getJarEntry(path = name.replace('.', '/').concat(".class"))) != null) {
            CodeSigner[] signers;
            CodeSource source;
            byte[] classBytes;
            block16: {
                String pkgName;
                try (InputStream inputStream = this.jar.getInputStream(entry);){
                    classBytes = ByteStreams.toByteArray((InputStream)inputStream);
                }
                catch (IOException ex) {
                    throw new ClassNotFoundException(name, ex);
                }
                int dot = name.lastIndexOf(46);
                if (dot != -1 && this.getPackage(pkgName = name.substring(0, dot)) == null) {
                    try {
                        if (this.manifest != null) {
                            this.definePackage(pkgName, this.manifest, this.url);
                        } else {
                            this.definePackage(pkgName, null, null, null, null, null, null, null);
                        }
                    }
                    catch (IllegalArgumentException ex) {
                        if (this.getPackage(pkgName) != null) break block16;
                        throw new IllegalStateException("Cannot find package " + pkgName);
                    }
                }
            }
            if ((result = this.defineClass(name, classBytes, 0, classBytes.length, source = new CodeSource(this.url, signers = entry.getCodeSigners()))) == null) {
                result = super.findClass(name);
            }
            this.classes.put(name, result);
        }
        return result;
    }

    @Override
    public URL getResource(String name) {
        return this.findResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        return this.findResources(name);
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            this.jar.close();
        }
    }

    @Generated
    public DuelsExtension getExtension() {
        return this.extension;
    }
}

