/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.gui.bind.buttons;

import com.meteordevelopments.duels.DuelsPlugin;
import com.meteordevelopments.duels.arena.ArenaImpl;
import com.meteordevelopments.duels.gui.BaseButton;
import com.meteordevelopments.duels.gui.bind.BindGui;
import com.meteordevelopments.duels.kit.KitImpl;
import com.meteordevelopments.duels.util.StringUtil;
import com.meteordevelopments.duels.util.compat.Items;
import com.meteordevelopments.duels.util.inventory.ItemBuilder;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bukkit.entity.Player;

public class BindButton
extends BaseButton {
    private final KitImpl kit;
    private final ArenaImpl arena;
    private BindGui gui;

    public BindButton(DuelsPlugin plugin, KitImpl kit, ArenaImpl arena) {
        super(plugin, ItemBuilder.of(Items.EMPTY_MAP).build());
        this.kit = kit;
        this.arena = arena;
        this.setDisplayName(plugin.getLang().getMessage("GUI.bind.buttons.arena.name", "arena", arena.getName()));
        this.update();
    }

    private void update() {
        boolean state = this.arena.isBound(this.kit);
        this.setGlow(state);
        String kits = StringUtil.join(this.arena.getKits().stream().map(KitImpl::getName).collect(Collectors.toList()), ", ");
        kits = kits.isEmpty() ? this.lang.getMessage("GENERAL.none") : kits;
        this.setLore(this.lang.getMessage("GUI.bind.buttons.arena.lore-" + (state ? "bound" : "not-bound"), "kits", kits).split("\n"));
    }

    @Override
    public void onClick(Player player) {
        this.arena.bind(this.kit);
        this.update();
        this.gui.calculatePages();
    }

    @Generated
    public void setGui(BindGui gui) {
        this.gui = gui;
    }
}

