/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.gui.settings;

import com.meteordevelopments.duels.DuelsPlugin;
import com.meteordevelopments.duels.config.Config;
import com.meteordevelopments.duels.gui.BaseButton;
import com.meteordevelopments.duels.gui.settings.buttons.ArenaSelectButton;
import com.meteordevelopments.duels.gui.settings.buttons.CancelButton;
import com.meteordevelopments.duels.gui.settings.buttons.ItemBettingButton;
import com.meteordevelopments.duels.gui.settings.buttons.KitSelectButton;
import com.meteordevelopments.duels.gui.settings.buttons.OwnInventoryButton;
import com.meteordevelopments.duels.gui.settings.buttons.RequestDetailsButton;
import com.meteordevelopments.duels.gui.settings.buttons.RequestSendButton;
import com.meteordevelopments.duels.util.compat.Items;
import com.meteordevelopments.duels.util.gui.Button;
import com.meteordevelopments.duels.util.gui.SinglePageGui;
import com.meteordevelopments.duels.util.inventory.Slots;
import java.util.ArrayList;
import org.bukkit.inventory.ItemStack;

public class SettingsGui
extends SinglePageGui<DuelsPlugin> {
    private static final int[][] PATTERNS = new int[][]{{13}, {12, 14}, {12, 13, 14}, {12, 13, 14, 22}};

    public SettingsGui(DuelsPlugin plugin) {
        super(plugin, plugin.getLang().getMessage("GUI.settings.title"), 3);
        Config config = plugin.getConfiguration();
        ItemStack spacing = Items.from(config.getSettingsFillerType(), config.getSettingsFillerData());
        Slots.run(2, 7, slot -> this.inventory.setItem(slot.intValue(), spacing));
        Slots.run(11, 16, slot -> this.inventory.setItem(slot.intValue(), spacing));
        Slots.run(20, 25, slot -> this.inventory.setItem(slot.intValue(), spacing));
        this.set(4, new RequestDetailsButton(plugin));
        ArrayList<BaseButton> buttons = new ArrayList<BaseButton>();
        if (config.isKitSelectingEnabled()) {
            buttons.add(new KitSelectButton(plugin));
        }
        if (config.isOwnInventoryEnabled()) {
            buttons.add(new OwnInventoryButton(plugin));
        }
        if (config.isArenaSelectingEnabled()) {
            buttons.add(new ArenaSelectButton(plugin));
        }
        if (config.isItemBettingEnabled()) {
            buttons.add(new ItemBettingButton(plugin));
        }
        if (!buttons.isEmpty()) {
            int[] pattern = PATTERNS[buttons.size() - 1];
            for (int i = 0; i < buttons.size(); ++i) {
                this.set(pattern[i], (Button)buttons.get(i));
            }
        }
        this.set(0, 2, 3, new RequestSendButton(plugin));
        this.set(7, 9, 3, new CancelButton(plugin));
    }
}

