/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.hook.hooks;

import com.meteordevelopments.duels.DuelsPlugin;
import com.meteordevelopments.duels.config.Config;
import com.meteordevelopments.duels.data.UserData;
import com.meteordevelopments.duels.data.UserManagerImpl;
import com.meteordevelopments.duels.util.hook.PluginHook;
import java.util.Arrays;
import me.robin.leaderheads.datacollectors.OnlineDataCollector;
import me.robin.leaderheads.objects.BoardType;
import org.bukkit.entity.Player;

public class LeaderHeadsHook
extends PluginHook<DuelsPlugin> {
    public static final String NAME = "LeaderHeads";
    private final Config config;
    private final UserManagerImpl userManager;

    public LeaderHeadsHook(DuelsPlugin plugin) {
        super(plugin, NAME);
        this.config = plugin.getConfiguration();
        this.userManager = plugin.getUserManager();
        plugin.doSyncAfter(() -> {
            new DuelWinsCollector(this.config.getLhWinsTitle(), this.config.getLhWinsCmd());
            new DuelLossesCollector(this.config.getLhLossesTitle(), this.config.getLhLossesCmd());
        }, 1L);
    }

    public class DuelWinsCollector
    extends OnlineDataCollector {
        DuelWinsCollector(String title, String command) {
            super("duels-wins", "Duels", BoardType.DEFAULT, title, command, Arrays.asList(null, null, null, null));
        }

        public Double getScore(Player player) {
            UserData user = LeaderHeadsHook.this.userManager.get(player);
            return user != null ? (double)user.getWins() : 0.0;
        }
    }

    public class DuelLossesCollector
    extends OnlineDataCollector {
        DuelLossesCollector(String title, String command) {
            super("duels-losses", "Duels", BoardType.DEFAULT, title, command, Arrays.asList(null, null, null, null));
        }

        public Double getScore(Player player) {
            UserData user = LeaderHeadsHook.this.userManager.get(player);
            return user != null ? (double)user.getLosses() : 0.0;
        }
    }
}

