/*
 * Decompiled with CFR 0.152.
 */
package com.meteordevelopments.duels.hook.hooks;

import com.meteordevelopments.duels.DuelsPlugin;
import com.meteordevelopments.duels.api.arena.Arena;
import com.meteordevelopments.duels.api.match.Match;
import com.meteordevelopments.duels.data.UserData;
import com.meteordevelopments.duels.kit.KitImpl;
import com.meteordevelopments.duels.spectate.SpectatorImpl;
import com.meteordevelopments.duels.util.StringUtil;
import com.meteordevelopments.duels.util.compat.Ping;
import com.meteordevelopments.duels.util.hook.PluginHook;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.apache.commons.lang.time.DurationFormatUtils;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlaceholderHook
extends PluginHook<DuelsPlugin> {
    public static final String NAME = "PlaceholderAPI";

    public PlaceholderHook(DuelsPlugin plugin) {
        super(plugin, NAME);
        new Placeholders().register();
    }

    public class Placeholders
    extends PlaceholderExpansion {
        public String getIdentifier() {
            return "duels";
        }

        public String getAuthor() {
            return "DUMBO";
        }

        public String getVersion() {
            return "1.0";
        }

        public boolean persist() {
            return true;
        }

        @Nullable
        public String onPlaceholderRequest(Player player, @NotNull String identifier) {
            KitImpl kit;
            if (player == null) {
                return "Player is required";
            }
            switch (identifier) {
                case "wins": {
                    UserData user = ((DuelsPlugin)PlaceholderHook.this.plugin).getUserManager().get(player);
                    if (user == null) {
                        return StringUtil.color(((DuelsPlugin)PlaceholderHook.this.plugin).getConfiguration().getUserNotFound());
                    }
                    return String.valueOf(user.getWins());
                }
                case "losses": {
                    UserData user = ((DuelsPlugin)PlaceholderHook.this.plugin).getUserManager().get(player);
                    if (user == null) {
                        return StringUtil.color(((DuelsPlugin)PlaceholderHook.this.plugin).getConfiguration().getUserNotFound());
                    }
                    return String.valueOf(user.getLosses());
                }
                case "can_request": {
                    UserData user = ((DuelsPlugin)PlaceholderHook.this.plugin).getUserManager().get(player);
                    if (user == null) {
                        return StringUtil.color(((DuelsPlugin)PlaceholderHook.this.plugin).getConfiguration().getUserNotFound());
                    }
                    return String.valueOf(user.canRequest());
                }
                case "wl_ratio": 
                case "wlr": {
                    UserData user = ((DuelsPlugin)PlaceholderHook.this.plugin).getUserManager().get(player);
                    if (user == null) {
                        return StringUtil.color(((DuelsPlugin)PlaceholderHook.this.plugin).getConfiguration().getUserNotFound());
                    }
                    int wins = user.getWins();
                    int losses = user.getLosses();
                    return String.valueOf(this.wlr(wins, losses));
                }
            }
            if (identifier.startsWith("rating_")) {
                UserData user = ((DuelsPlugin)PlaceholderHook.this.plugin).getUserManager().get(player);
                if (user == null) {
                    return StringUtil.color(((DuelsPlugin)PlaceholderHook.this.plugin).getConfiguration().getUserNotFound());
                }
                if ((identifier = identifier.replace("rating_", "")).equals("-")) {
                    return String.valueOf(user.getRating());
                }
                kit = ((DuelsPlugin)PlaceholderHook.this.plugin).getKitManager().get(identifier);
                return kit != null ? String.valueOf(user.getRating(kit)) : StringUtil.color(((DuelsPlugin)PlaceholderHook.this.plugin).getConfiguration().getNoKit());
            }
            if (identifier.startsWith("getplayersinqueue_")) {
                UserData user = ((DuelsPlugin)PlaceholderHook.this.plugin).getUserManager().get(player);
                if (user == null) {
                    return StringUtil.color(((DuelsPlugin)PlaceholderHook.this.plugin).getConfiguration().getUserNotFound());
                }
                identifier = identifier.replace("getplayersinqueue_", "");
                kit = ((DuelsPlugin)PlaceholderHook.this.plugin).getKitManager().get(identifier);
                if (kit == null) {
                    return StringUtil.color(((DuelsPlugin)PlaceholderHook.this.plugin).getConfiguration().getNoKit());
                }
                int queuedPlayers = ((DuelsPlugin)PlaceholderHook.this.plugin).getQueueManager().get(kit, 0).getQueuedPlayers().size();
                return queuedPlayers > 0 ? String.valueOf(queuedPlayers) : "0";
            }
            if (identifier.startsWith("getplayersplayinginqueue_")) {
                UserData user = ((DuelsPlugin)PlaceholderHook.this.plugin).getUserManager().get(player);
                if (user == null) {
                    return StringUtil.color(((DuelsPlugin)PlaceholderHook.this.plugin).getConfiguration().getUserNotFound());
                }
                identifier = identifier.replace("getplayersplayinginqueue_", "");
                kit = ((DuelsPlugin)PlaceholderHook.this.plugin).getKitManager().get(identifier);
                if (kit == null) {
                    return StringUtil.color(((DuelsPlugin)PlaceholderHook.this.plugin).getConfiguration().getNoKit());
                }
                long playersInMatch = ((DuelsPlugin)PlaceholderHook.this.plugin).getQueueManager().get(kit, 0).getPlayersInMatch();
                return Long.toString(playersInMatch);
            }
            if (identifier.startsWith("match_")) {
                Match match;
                identifier = identifier.replace("match_", "");
                Arena arena = ((DuelsPlugin)PlaceholderHook.this.plugin).getArenaManager().get(player);
                if (arena == null) {
                    SpectatorImpl spectator = ((DuelsPlugin)PlaceholderHook.this.plugin).getSpectateManager().get(player);
                    if (spectator == null) {
                        return StringUtil.color(((DuelsPlugin)PlaceholderHook.this.plugin).getConfiguration().getNotInMatch());
                    }
                    arena = spectator.getArena();
                    player = spectator.getTarget();
                    if (player == null) {
                        return StringUtil.color(((DuelsPlugin)PlaceholderHook.this.plugin).getConfiguration().getNotInMatch());
                    }
                }
                if ((match = arena.getMatch()) == null) {
                    return StringUtil.color(((DuelsPlugin)PlaceholderHook.this.plugin).getConfiguration().getNotInMatch());
                }
                if (identifier.equalsIgnoreCase("duration")) {
                    return DurationFormatUtils.formatDuration((long)(System.currentTimeMillis() - match.getStart()), (String)((DuelsPlugin)PlaceholderHook.this.plugin).getConfiguration().getDurationFormat());
                }
                if (identifier.equalsIgnoreCase("kit")) {
                    return match.getKit() != null ? match.getKit().getName() : StringUtil.color(((DuelsPlugin)PlaceholderHook.this.plugin).getConfiguration().getNoKit());
                }
                if (identifier.equalsIgnoreCase("arena")) {
                    return match.getArena().getName();
                }
                if (identifier.equalsIgnoreCase("bet")) {
                    return String.valueOf(match.getBet());
                }
                if (identifier.equalsIgnoreCase("rating")) {
                    UserData user = ((DuelsPlugin)PlaceholderHook.this.plugin).getUserManager().get(player);
                    if (user == null) {
                        return StringUtil.color(((DuelsPlugin)PlaceholderHook.this.plugin).getConfiguration().getUserNotFound());
                    }
                    return String.valueOf(match.getKit() != null ? user.getRating(match.getKit()) : user.getRating());
                }
                if (identifier.startsWith("opponent")) {
                    Player opponent = null;
                    for (Player matchPlayer : match.getPlayers()) {
                        if (matchPlayer.equals((Object)player)) continue;
                        opponent = matchPlayer;
                        break;
                    }
                    if (opponent == null) {
                        return StringUtil.color(((DuelsPlugin)PlaceholderHook.this.plugin).getConfiguration().getNoOpponent());
                    }
                    if (identifier.equalsIgnoreCase("opponent")) {
                        return opponent.getName();
                    }
                    if (identifier.endsWith("_health")) {
                        return String.valueOf(Math.ceil(opponent.getHealth()) * 0.5);
                    }
                    if (identifier.endsWith("_ping")) {
                        return String.valueOf(Ping.getPing(opponent));
                    }
                    UserData user = ((DuelsPlugin)PlaceholderHook.this.plugin).getUserManager().get(opponent);
                    if (user == null) {
                        return StringUtil.color(((DuelsPlugin)PlaceholderHook.this.plugin).getConfiguration().getUserNotFound());
                    }
                    return String.valueOf(match.getKit() != null ? user.getRating(match.getKit()) : user.getRating());
                }
            }
            return null;
        }

        private float wlr(int wins, int losses) {
            if (wins == 0) {
                return losses == 0 ? 0.0f : (float)(-losses);
            }
            if (losses == 0) {
                return wins;
            }
            return wins / losses;
        }
    }
}

